
package Mail::SpamAssassin::CompiledRegexps::body_0;

use strict;
use vars qw($VERSION @ISA @EXPORT_OK);

use XSLoader ();

BEGIN {
$VERSION = '1.0';
@ISA = qw(XSLoader);
@EXPORT_OK = qw();

our $HAS_RULES = {
    q#ACT_NOW_CAPS,[l=1]# => q#/\bA(?i:ct) N(?i:ow)\b/#,
  q#BAD_CREDIT,[l=1]# => q#/\b((?:bad|poor|eliminate|repair|(?:re)?establish|damag).{0,10} (?:credit|debt)|no credit (?:check|histor|need))/i#,
  q#BANG_GUAR,[l=1]# => q#/\bguaranteed?\!/i#,
  q#BANG_OPRAH,[l=1]# => q#/\boprah!/i#,
  q#BANKING_LAWS,[l=0]# => q#/banking laws/i#,
  q#BILLION_DOLLARS,[l=1]# => q#/[BM]ILLION DOLLAR/#,
  q#BODY_ENHANCEMENT,[l=1]# => q#/\b(?:enlarge|increase|grow|lengthen|larger\b|bigger\b|longer\b|thicker\b|\binches\b).{0,50}\b(?:penis|male organ|pee[ -]?pee|dick|sc?hlong|wh?anger|breast(?!\s+cancer))/i#,
  q#BODY_ENHANCEMENT2,[l=1]# => q#/\b(?:penis|male organ|pee[ -]?pee|dick|sc?hlong|wh?anger|breast(?!\s+cancer)).{0,50}\b(?:enlarge|increase|grow|lengthen|larger\b|bigger\b|longer\b|thicker\b|\binches\b|size)/i#,
  q#CUM_SHOT,[l=1]# => q#/\bcum[ -]?shots?\b/i#,
  q#CURR_PRICE,[l=1]# => q#/\bCurrent Price:/#,
  q#DEAR_SOMETHING,[l=1]# => q#/\bDear (?:IT\W|Internet|candidate|sirs?|madam|investor|travell?er|car shopper|web)\b/i#,
  q#DEAR_WINNER,[l=1]# => q#/\bdear.{1,20}winner/i#,
  q#DIET_1,[l=1]# => q#/\b(?:(?:without|no) (?:exercis(?:e(?! price)|ing)|dieting)|weight.?loss|(?:extra|lose|lost|losing).{0,10}(?:pounds|weight|inches|lbs)|burn.{1,10}fat)\b/i#,
  q#DRUGS_SMEAR1,[l=1]# => q#/(?:Viagra|Valium|Xanax|Soma|Cialis){2}/i#,
  q#DRUG_ED_CAPS,[l=1]# => q#/\b(?:CIALIS|LEVITRA|VIAGRA)/#,
  q#DRUG_ED_GENERIC,[l=1]# => q#/\bGeneric Viagra\b/#,
  q#DRUG_ED_ONLINE,[l=1]# => q#/\bviagra .{0,25}(?:express|online|overnight)/i#,
  q#DRUG_ED_SILD,[l=1]# => q#/\bsildenafil\b/i#,
  q#DX_TEXT_03,[l=1]# => q#/\b[A-Z]{3} Media (?:Group|Relations)\b/#,
  q#EM_ROLEX,[l=1]# => q#/[^\s\w.]rolex/i#,
  q#EXCUSE_24,[l=1]# => q#/you(?:'ve|'re| have| are)? receiv(?:e|ed|ing) this (?:advertisement|offer|special|recurring|paid).{0,16}\b(?:by either|because)/i#,
  q#EXCUSE_4,[l=1]# => q#/To Be Removed,? Please/i#,
  q#EXCUSE_REMOVE,[l=1]# => q#/to be removed from.{0,20}(?:mailings|offers)/i#,
  q#FIN_FREE,[l=1]# => q#/\bfinancial(?:ly)? (?:free|independen)/i#,
  q#FORWARD_LOOKING,[l=1]# => q#/\bcontains forward-looking statements\b/i#,
  q#FREE_PORN,[l=1]# => q#/\bfree (?:porn|xxx|adult)/i#,
  q#FREE_QUOTE_INSTANT,[l=1]# => q#/free.{0,12}(?:(?:instant|express|online|no.?obligation).{0,4})+.{0,32}\bquote/i#,
  q#FSL_THIS_IS_ADV,[l=1]# => q#/This is an advertisement\./#,
  q#GTUBE,[l=1]# => q#/XJS\*C4JDBQADN1\.NSBN3\*2IDNEN\*GTUBE-STANDARD-ANTI-UBE-TEST-EMAIL\*C\.34X/#,
  q#GUARANTEED_100_PERCENT,[l=0]# => q#/100% GUARANTEED/i#,
  q#HK_SCAM_N8,[l=1]# => q#/\byour compensation\b/i#,
  q#IMH_BAD_LINKS_BODY,[l=1]# => q#/\/[a-z]{3,4}\/(?:news(?:_|-)[a-z]{1,2}|[a-z]{1,2}(?:_|-)news)\.php">|start.php\?fdx=|(dirs|help|include|title|test|stats|template|proxy|cache|press|header|footer|error|options|db)\.php\?[a-z]\=[0-9]{2}|dir\.html\?|cache\.html\?|lib\.html|css\.html|footer\.html|test\.html|\/gallery\.html\?YWp|ini\.html|config\.html|system\.html|functions\.html\?|template\.html|plugin\.html\?|error\.html\?|defines\.html\?|inc\.html|header\.html|session\.html|open_me\.htm/#,
  q#IMH_BAD_MISC_BODY,[l=1]# => q#/Content\-Disposition\:\ attachment\;\ filename\=\"Login\.html\"/#,
  q#IMH_CLICK_HERE,[l=1]# => q#/Hi,\s[^\s@]+\s\->\ Click Here/#,
  q#IMH_ED_SPAM,[l=1]# => q#/(:?\b(:?appraise|arous(?:ed?|ing|al)|babes?|beaut(:?ies|y)|bed.?rooms?|boners?|buy|chicks?|discounts?|drugs?|dysfunction(:?al|s)?|ed|erecti(:?on|le)s?|ejaculat(:?e|ion|ing)|free|formulas?|guarantee(:?s|ed)?|girls?|hard(:?.?ons?)|hook.?ups?|hot(:?test|ies?)?|impoten(:?ce|t)|lad(:?ies|y)|libido|limp(:?ness)?|lonely|masturbat(:?e|ing|ion)|med(:?ication|icine|icament)?s?|men.?s\shealth|nymphs?|pleasur(:?ed?|able|ing)|pills?|poten(:?t|cy)|prescription(:?-free|s)?|prices?|(:?web)?cam(:?girl)?s?|remedy|sales?|seduc(:?e|tion|ed|tive)|sex(chat|ual|treme|y)?|stiffy?|tab(:?let)?s?|techniques?|viril(:?e|ity)|wife)\b.+){2,}/i#,
  q#IMH_POSSIBLY_BAD_WORDS,[l=1]# => q#/\b(?:teen|busty|booty|pussy|sexy|fuck|bikini|suck|cumm*|squirt|swallow|amat(?:ure|eur)|naked|nude|rammed|cheerleader|slut(?:ty)|interracial|oiled|shemale|swallow|squirt)(?:s|er|ing)?\b/i#,
  q#IMH_REALLY_BAD_WORDS,[l=1]# => q#/\b(?:gerbil+ing|facefuck|fuckface|horny|c(o|0)ck|anal|ass\s?pound|masturbat(?:ion)|do(?:g|o)g(?:ie|y)\s?style|glory\shole|cunt|creampie|tit(?:t(?:y|ie))?|dildo|blow\s?job|ass.to.mouth)(?:e?s|er|ing)?\b/i#,
  q#IMH_SUSPECT_NEWSLETTER,[l=1]# => q#/\/newsletter\/statistics\/link\.php/#,
  q#IMPOTENCE,[l=1]# => q#/\b(?:impotence (?:problem|cure|solution)|Premature Ejaculation|erectile dysfunction)/i#,
  q#INVESTMENT_ADVICE,[l=1]# => q#/\binvestment advice/i#,
  q#JOIN_MILLIONS,[l=1]# => q#/\bjoin (?:millions|thousands)\b/i#,
  q#KAM_ADVERT3,[l=1]# => q#/AllExpiringDomains.com/i#,
  q#KAM_BODY,[l=0]# => q#/{_BODY_HTML}/i#,
  q#KAM_CANSPAM,[l=1]# => q#/(full compliance with the U.S. Federal-?Can-?Spam-Act|provides CAN-SPAM compliant email|consistent with the provisions of the CAN-SPAM Act|compliance with the CanSpam Act|no deceptive subject lines|compliant with all legal provisions of the CAN-SPAM Act)/is#,
  q#KAM_HOLLY,[l=0]# => q#/1 0 2 0 N H o l l y w o o d W a y /i#,
  q#KAM_OBFU_LOANS,[l=0]# => q#/Stüdént Lóans/i#,
  q#KAM_OVERPAY,[l=1]# => q#/O . V . E . R . P . A . Y/i#,
  q#KAM_PERPARK,[l=0]# => q#/P e r i m e t e r P a r k C e n t e r/i#,
  q#KAM_PUBLIC,[l=1]# => q#/obtained your email address from a publicly available list|find your mail in public forum/is#,
  q#KAM_REACHBASE,[l=0]# => q#/ReachBase is committed to providing you with relevant business information/i#,
  q#KAM_TRUTHINESS,[l=1]# => q#/[Tt]he TRUTH/#,
  q#KAM_VIAGRA1,[l=0]# => q#/V I A G R A|C I A L I S|V A L I U M|X A N A X/i#,
  q#KAM_VIAGRA2,[l=0]# => q#/(?:Xan|Som|CIA|VAL|VIA|Pro|Amb|Lev|Mer) (?:Xan|Som|CIA|VAL|VIA|Pro|Amb|Lev|Mer) (?:Xan|Som|CIA|VAL|VIA|Pro|Amb|Lev|Mer)/i#,
  q#KAM_VIAGRA5,[l=1]# => q#/(V [1li|\]] [a&] G R A|VljAG+R+A)/i#,
  q#LIVE_PORN,[l=1]# => q#/\blive .{0,9}(?:fuck(?:ing)?|sex|naked|girls?|virgins?|teens?|porno?)\b/i#,
  q#LONG_TERM_PRICE,[l=1]# => q#/long\W+term\W+(target|projected)(\W+price)?/i#,
  q#LOOPHOLE_1,[l=1]# => q#/loop-?hole in the banking/i#,
  q#LOW_PRICE,[l=1]# => q#/\blow.{0,4} (?-i:P)rice/i#,
  q#MALE_ENHANCE,[l=0]# => q#/male enhancement/i#,
  q#MARKETING_PARTNERS,[l=1]# => q#/\b(?:marketing|network) partner|\bpartner (?:web)?site/i#,
  q#MONEY_BACK,[l=0]# => q#/money back guarantee/i#,
  q#MORE_SEX,[l=1]# => q#/increased?.{0,9}(?:sex|stamina)/i#,
  q#NOT_ADVISOR,[l=0]# => q#/not a registered investment advisor/i#,
  q#NO_MEDICAL,[l=1]# => q#/\bno medical exam/i#,
  q#NO_PRESCRIPTION,[l=1]# => q#/N[o0].{1,10}P(?:er|re)scr[i1]pt[i1][o0]n.{1,10}(?:n[e3][e3]d[e3]d|requ[1i]re|n[e3]c[e3]ssary)/i#,
  q#ONE_TIME,[l=1]# => q#/\bone\W+time (?:charge|investment|offer|promotion)/i#,
  q#ONLINE_PHARMACY,[l=1]# => q#/\bonline pharmacy|\b(?:drugs|medications) online/i#,
  q#PREST_NON_ACCREDITED,[l=1]# => q#/prestigi?ous\b.{0,20}\bnon-accredited\b.{0,20}\buniversities/i#,
  q#PRICES_ARE_AFFORDABLE,[l=1]# => q#/\baffordable .{0,10}prices\b/i#,
  q#REFINANCE_NOW,[l=1]# => q#/time to refinance|refinanc\w{1,3}\b.{0,16}\bnow\b/i#,
  q#REFINANCE_YOUR_HOME,[l=1]# => q#/\brefinance your(?: current)? (?:home|house)\b/i#,
  q#REMOVE_BEFORE_LINK,[l=1]# => q#m{(?:no thanks|not interested|unsubscribe here).{0,5}http://}i#,
  q#REPLICA_WATCH,[l=1]# => q#/\breplica.{1,20}rolex/i#,
  q#SHORT_TERM_PRICE,[l=1]# => q#/short\W+term\W+(target|projected)(\W+price)?/i#,
  q#STOCK_ALERT,[l=1]# => q#/\bstock alert/i#,
  q#STRONG_BUY,[l=0]# => q#/strong buy/i#,
  q#TVD_ACT_193,[l=1]# => q#/\bact of (?:193|nineteen thirty)/i#,
  q#TVD_APPROVED,[l=1]# => q#/you.{1,2}re .{0,20}approved/i#,
  q#TVD_INCREASE_SIZE,[l=1]# => q#/\bsize of .{1,20}(?:penis|dick|manhood)/i#,
  q#TVD_LINK_SAVE,[l=1]# => q#/\blink to save\b/i#,
  q#TVD_PH_REC,[l=1]# => q#/\byour .{0,40}account .{0,40}record/i#,
  q#TVD_PH_SEC,[l=1]# => q#/\byour .{0,40}account .{0,40}security/i#,
  q#TVD_QUAL_MEDS,[l=1]# => q#/\bquality med(?:ication)?s\b/i#,
  q#TVD_SECTION,[l=1]# => q#/\bSection (?:27A|21B)/i#,
  q#TVD_VISIT_PHARMA,[l=1]# => q#/Online Ph.rmacy/i#,
  q#T_DEAR_BENEFICIARY,[l=1]# => q#/\b(?:De[ae]r\s|At+(?:ention|n):?\s?)(?:\S+\s)?Ben[ei]ficiary\b/i#,
  q#T_EMRCP,[l=1]# => q#/\bExcess (?:Maximum )?Return Capital (?:Profits?|Funds?)\b/i#,
  q#UNCLAIMED_MONEY,[l=1]# => q#/\bunclaimed\s(?:assets?|accounts?|mon(?:ey|ies)|balance|funds?|prizes?|rewards?|payments?|deposits?)\b/i#,
  q#URG_BIZ,[l=1]# => q#/urgent.{0,16}(?:assistance|business|buy|confidential|notice|proposal|reply|request|response)/i#,
  q#VIA_GAP_GRA,[l=1]# => q#/\bvia.gra\b/i#,
  q#__ACCESS_RESTORE,[l=1]# => q#/\bto (?:(?:restore|regain) access|(?:remove|uplift) (?:the|this) suspens|continue using your (?:account|online))/i#,
  q#__ACCESS_REVOKE,[l=1]# => q#/(?:temporary|permanent) (?:de-?activation|removal) of your (?:\w{1,30} )?(?:access|account)/i#,
  q#__ACCOUNT_DISRUPT,[l=0]# => q#/ensure (?:that )?your (?:account|access) is not (?:disrupted|suspended|interrupted)/i#,
  q#__ACCOUNT_ERROR,[l=0]# => q#/your account (?:is|appears to be) (?:incorrect|missing|in error|invalid)/i#,
  q#__ACCOUNT_UPGRADE,[l=1]# => q#/(?:upgrade (?:of )your (?:account|access)|your (?:access|account) is[\w\s]{0,40}being upgraded)/i#,
  q#__ACH_CANCELLED_02,[l=1]# => q#/(?:rejected|cancel+ed|declined|your)[-_ ](?:(?-i:ACH)|direct[-_ ]deposit)[-_ ](?:payment|transfer|transaction|declin(?:ed|ing))/i#,
  q#__ACH_CANCELLED_03,[l=1]# => q#/\bwire[-_ ]?(?:payment|transfer|transaction)[-_ ](?:(?:was|is)[-_ ])?(?:rejected|cancel+ed|declined|disabled|not[-_ ]accepted|(?:technical )?error)/i#,
  q#__ACH_CANCELLED_04,[l=1]# => q#/\bregarding[-_ ]your[-_ ]direct[-_ ]deposit[-_ ]via[-_ ](?-i:ACH)/i#,
  q#__ADMAIL,[l=1]# => q#/(?:\b|_)ad-?(?:mail|message)s?(?:\b|_)/i#,
  q#__ADMITS_SPAM,[l=1]# => q#/\bth(?:e[- ]+above|is)(?:\?+s|[- ]+is)[- ]+(?:intended[- ]+as[- ]+)?an?[- ]+(?:email[- ]+)?[a@]dvert[i1l]sement\b/i#,
  q#__AFF_LOTTERY,[l=0]# => q#/(?:lottery|winner)/i#,
  q#__AFR_UNION,[l=1]# => q#/\bafrican\sunion\b/i#,
  q#__AGREED_RATIO,[l=1]# => q#/\b(?:agreed|sharing)\s(?:ratios?|percent\w+)\b/i#,
  q#__AM_DYING,[l=1]# => q#/\b(?:am\s(?:\S+\s)?dying|terminally\sill|cancer|en\sphase\sterminale|(?:become|is|devenu|maladie)\sincurable|que\sje\smeurs)\b/i#,
  q#__AUTO_ACCIDENT,[l=0]# => q#/auto(?:mobile)? accident/i#,
  q#__BACK_SCRATCH,[l=1]# => q#/\bmutual+y?\s(?:benefi(?:t|cial)|interest)\b/i#,
  q#__BANK_DRAFT,[l=1]# => q#/\bbank\sdraft/i#,
  q#__BARRISTER,[l=1]# => q#/\b(?:barrister|solicitor at law|barr\.)/i#,
  q#__BENIN,[l=1]# => q#/\bb(?:e|=E9|[\xe9]|[\xc3][\xa9])nin\b/i#,
  q#__BODY_XHTML,[l=0]# => q#/<x-html>/i#,
  q#__BOUNCE_NEVER_SEE,[l=1]# => q#/\bThis is an autoresponder. I'll never see your message\b/i#,
  q#__BOUNCE_NONWORKING,[l=1]# => q#/\bYou have reached a non.?working address.  Please check\b/i#,
  q#__BOUNCE_NO_RESEND,[l=1]# => q#/\bPlease do not resend your original message\./#,
  q#__BOUNCE_OOO_2,[l=1]# => q#/\bI ?.m away until .{10,20} and am unable to read your message\b/#,
  q#__BOUNCE_OOO_3,[l=1]# => q#/\bI am currently out of the office\b/#,
  q#__BURKINA_FASO,[l=1]# => q#/\bburkina\s?faso\b/i#,
  q#__CAN_HELP,[l=1]# => q#/\bcan help\b/i#,
  q#__CASHPRZ,[l=1]# => q#/cash prize of/#,
  q#__CHARITY,[l=1]# => q#/\b(?:charit(?:y|[ai]ble)|orphans?|homeless|orphelins|sans\sabri)\b/i#,
  q#__CLEAN_MAILBOX,[l=1]# => q#/\b(?:(?:e-?mail|mail\s?box|violation:|(?-i:CLICK)) (?:quota size|clean(?:-?up))|clean ?up click ?here)\b/i#,
  q#__CLICK_HERE,[l=1]# => q#/\bclick\shere\b/i#,
  q#__COMPENSATION,[l=1]# => q#/\b(?:compensat(?:e|ion)|recompensed?|ausgleich)\b/i#,
  q#__CONTACT_ATTY,[l=1]# => q#/\bcontact(?:er)?\s(?:my|(?:de\s)?mon)\s(?:barrister|attou?rney|lawyer|avocat|gestionnaire)\b/i#,
  q#__CONTACT_YOU,[l=1]# => q#/\b(?:contact(?:ing)\syou|vous\scontacter?)\b/i#,
  q#__COURIER,[l=1]# => q#/\bcourier\s(?:company|service)\b/i#,
  q#__DBLCLAIM,[l=1]# => q#/avoid double claiming/#,
  q#__DEAL,[l=1]# => q#/\b(?:(?:business|financial|this|the|mutual|die(?:se)?r?|cette|profitable)\s(?:deal|transa[ck]tion|proposal|off[er]{2}|venture|suggestion|partnership)|your\spartnership)/i#,
  q#__DECEASED,[l=1]# => q#/\b(?:the|my|your|der|du|le|meu?)\s(?:deceased|late|verstorbenen|d(?:i|e|=E9|[\xe9]|[\xc3][\xa9])funto?|d(?:e|=E9|[\xe9]|[\xc3][\xa9])nt|falecido)\b/i#,
  q#__DESTROY_ME,[l=1]# => q#/\b(?:destroy|hunt|quemar)\sm[eyi]\b/i#,
  q#__DESTROY_YOU,[l=1]# => q#/\b(?:destroy\syou|deine Zukunft zerst\S{1,3}ren)/i#,
  q#__DIED_IN,[l=1]# => q#/\bdied\sin\b/i#,
  q#__DIPLOMATIC,[l=1]# => q#/\bdiplomatic\b/i#,
  q#__DLND_ATTACH,[l=1]# => q#/\bdownload\sthe\sattach(?:ed|ment)\b/i#,
  q#__DORMANT_ACCT,[l=1]# => q#/\b(?:(?:dormant|abandoned|left\s?over)\s(?:account|fund|transaction|sum|deposit)|fonds\sdorment)/i#,
  q#__DOS_BODY_FRI,[l=1]# => q#/\bfri(?:day)?\b/i#,
  q#__DOS_BODY_MON,[l=1]# => q#/\bmon(?:day)?\b/i#,
  q#__DOS_BODY_SAT,[l=1]# => q#/\bsat(?:day)?\b/i#,
  q#__DOS_BODY_STOCK,[l=1]# => q#/\bstock\b/i#,
  q#__DOS_BODY_SUN,[l=1]# => q#/\bsun(?:day)?\b/i#,
  q#__DOS_BODY_THU,[l=1]# => q#/\bthu(?:r(?:s(?:day)?)?)?\b/i#,
  q#__DOS_BODY_TICKER,[l=1]# => q#/\b[A-Z]{4}\.(?:OB|PK)\b/#,
  q#__DOS_BODY_TUE,[l=1]# => q#/\btue(?:s(?:day)?)?\b/i#,
  q#__DOS_BODY_WED,[l=1]# => q#/\bwed(?:nesday)?\b/i#,
  q#__DOS_CORRESPOND_EMAIL,[l=1]# => q#/correspond with me using my email/#,
  q#__DOS_DROP_ME_A_LINE,[l=1]# => q#/Drop me a line at/#,
  q#__DOS_EMAIL_DIRECTLY,[l=1]# => q#/(?:Email m[a-z]?e|address) direc(?:tl|lt)y at/#,
  q#__DOS_FIN_ADVANTAGE,[l=1]# => q#/\bfinancial advantage/i#,
  q#__DOS_I_AM_25,[l=1]# => q#/I a.?m 25/#,
  q#__DOS_I_DRIVE_A,[l=1]# => q#/I drive a/#,
  q#__DOS_LET_GO_JOB,[l=1]# => q#/I was (?:let go|fired|layed off|dismissed) from a job I h(?:el|a)d for (?:2\d years|\d{3} months)/#,
  q#__DOS_LINK,[l=1]# => q#/\blink\b/#,
  q#__DOS_MEET_EACH_OTHER,[l=1]# => q#/(?:meet each other|[Mm]ay ?be we can meet)/#,
  q#__DOS_MY_OLD_JOB,[l=1]# => q#/my old job/#,
  q#__DOS_PERSONAL_EMAIL,[l=1]# => q#/personal email at/#,
  q#__DOS_STEADY_COURSE,[l=1]# => q#/\bsteady (?:and increasing )?course\b/i#,
  q#__DOS_STRONG_CF,[l=1]# => q#/\bstrong cash flow/i#,
  q#__DOS_TAKING_HOME,[l=1]# => q#/Taking home \d (?:digit level|figures) in \d{1,2} months/#,
  q#__DOS_WRITE_ME_AT,[l=1]# => q#/[Ww].?r.?i.?t.?e me at/#,
  q#__DRUGS_ANXIETY2,[l=1]# => q#/\bAlprazolam\b/i#,
  q#__DRUGS_ANXIETY8,[l=1]# => q#/\bklonopin\b/i#,
  q#__DRUGS_ANXIETY9,[l=1]# => q#/\brivotril\b/i#,
  q#__DRUGS_ANXIETY_VAL,[l=0]# => q#/valium/i#,
  q#__DRUGS_ANXIETY_XAN,[l=1]# => q#/xan[ae]x/i#,
  q#__DRUGS_DIET3,[l=1]# => q#/\bbontril\b/i#,
  q#__DRUGS_DIET4,[l=1]# => q#/\bphendimetrazine\b/i#,
  q#__DRUGS_DIET5,[l=1]# => q#/\bdiethylpropion\b/i#,
  q#__DRUGS_DIET_PHEN,[l=1]# => q#/\bphentermine\b/i#,
  q#__DRUGS_ERECTILE2,[l=1]# => q#/\bV(?:agira|igara|iaggra|iaegra)\b/i#,
  q#__DRUGS_ERECTILE4,[l=1]# => q#/\bC(?:alis|ilias|ilais)\b/i#,
  q#__DRUGS_ERECTILE5,[l=1]# => q#/\b_{0,3}s[_\W]?[i1!|l\xEC-\xEF][_\W]?l[_\W]?d[_\W]?[e3\xE8-\xEB][_\W]?n[_\W]?[a4\xE0-\xE6@][_\W]?f[_\W]?[i1!|l\xEC-\xEF][_\W]?l c[_\W]?[i1!|l\xEC-\xEF][_\W]?t[_\W]?r[_\W]?[a4\xE0-\xE6@][_\W]?t[_\W]?[e3\xE8-\xEB]_{0,3}(?:\b|\s)/i#,
  q#__DRUGS_ERECTILE_C,[l=1]# => q#/\bCialis\b/i#,
  q#__DRUGS_ERECTILE_L,[l=1]# => q#/\bLevitra\b/i#,
  q#__DRUGS_ERECTILE_V,[l=1]# => q#/\bViagra\b/i#,
  q#__DRUGS_MUSCLE2,[l=1]# => q#/\b_{0,3}cycl[o0\xF2-\xF6]b[e3\xE8-\xEB]nz[a4\xE0-\xE6@]pr[i1!|l\xEC-\xEF]n[e3\xE8-\xEB]_{0,3}(?:\b|\s)/i#,
  q#__DRUGS_MUSCLE5,[l=1]# => q#/\bskelaxin\b/i#,
  q#__DRUGS_PAIN11,[l=1]# => q#/\bzebutal\b/i#,
  q#__DRUGS_PAIN12,[l=1]# => q#/\besgic plus\b/i#,
  q#__DRUGS_PAIN2,[l=1]# => q#/\b_{0,3}c[o0\xF2-\xF6]deine_{0,3}\b/i#,
  q#__DRUGS_PAIN_FIO,[l=0]# => q#/fioricet/i#,
  q#__DRUGS_PAIN_VICO,[l=0]# => q#/vicodin/i#,
  q#__DRUGS_PAIN_VIOXX,[l=0]# => q#/vioxx/i#,
  q#__EARLY_DEMISE,[l=1]# => q#/\buntimely\sdeath\b/i#,
  q#__FAILED_LOGINS,[l=1]# => q#/unsuc+es+ful log-?[io]n at+empts/i#,
  q#__FB_COST,[l=1]# => q#/\bcost\b/i#,
  q#__FB_S_STOCK,[l=1]# => q#/\bstock/i#,
  q#__FB_TOUR,[l=1]# => q#/\btour/i#,
  q#__FEES,[l=1]# => q#/\b(?:security|safe\w*|courier|registration|pay|paid|up-?front|processing|delivery|transfer|keeping)[\s\w]{0,15}\s(?:fee|charge)s?\b/i#,
  q#__FOR_SALE_LTP,[l=1]# => q#/00\.? (?:less 10%|LTP)/i#,
  q#__FOR_SALE_NET,[l=1]# => q#/00\.? NET/i#,
  q#__FOR_SALE_OBO,[l=1]# => q#/\bor best offer\b/i#,
  q#__FOR_SALE_PRC_100K,[l=1]# => q#/\bprice:? \$\d\d\d,\d\d\d/i#,
  q#__FOR_SALE_PRC_10K,[l=1]# => q#/\bprice:? \$\d\d,\d\d\d/i#,
  q#__FOR_SALE_PRC_1K,[l=1]# => q#/\bprice:? \$\d,?\d\d\d[.\s]/i#,
  q#__FOUND_YOU,[l=1]# => q#/\b(?:I|we)\sfound\syour?\b/i#,
  q#__FRAUD,[l=1]# => q#/\b(?:de)?fraud/i#,
  q#__FRAUD_AON,[l=1]# => q#/\b(?:confidential|private|alternate|alternative) (?:(?:e-? *)?mail)\b/i#,
  q#__FRAUD_AUM,[l=1]# => q#/\bthe desk of\b/i#,
  q#__FRAUD_AXF,[l=0]# => q#/magnanimity/i#,
  q#__FRAUD_BEP,[l=1]# => q#/\b(?:bank of nigeria|central bank of|trust bank|apex bank|amalgamated bank)\b/i#,
  q#__FRAUD_BGP,[l=1]# => q#/\battached to ticket number\b/i#,
  q#__FRAUD_CKF,[l=0]# => q#/computer ballot system/i#,
  q#__FRAUD_DPR,[l=1]# => q#/\b(?:(?:respond|reply) (?:urgently|immediately)|(?:urgent|immediate|earliest) (?:reply|response))\b/i#,
  q#__FRAUD_ETX,[l=1]# => q#/\byour\b[^.]{0,99}\b(?:contact (?:details|information)|private (?:e?[- ]?mail|telephone|tel|phone|fax))\b/i#,
  q#__FRAUD_EZY,[l=1]# => q#/\b(?:of|the) late president\b/i#,
  q#__FRAUD_FBI,[l=1]# => q#/\bdisburs/i#,
  q#__FRAUD_FCW,[l=0]# => q#/fiduciary agent/i#,
  q#__FRAUD_FVU,[l=0]# => q#/award notification/i#,
  q#__FRAUD_GBW,[l=1]# => q#/god gives .{1,10}second chance/i#,
  q#__FRAUD_IOU,[l=1]# => q#/\b(?:no risks?|risk-? *free|free of risks?|100% safe)\b/i#,
  q#__FRAUD_IOV,[l=1]# => q#/\b(?:no risks?|risky?[- ]{0,3}free|free of risks?|100% safe|v\S{1,3}llig Risikofrei ist)\b/i#,
  q#__FRAUD_IPK,[l=1]# => q#/\b(?:in|to|visit) your country\b/i#,
  q#__FRAUD_IRJ,[l=0]# => q#/(?:finance|holding|securit(?:ies|y)) (?:company|firm|storage house)/i#,
  q#__FRAUD_IRT,[l=1]# => q#/\b(?:compliments? of the|dear friend|dear sir|yours faithfully|season'?s greetings)\b/i#,
  q#__FRAUD_JBU,[l=1]# => q#/\bforeign account\b/i#,
  q#__FRAUD_JNB,[l=1]# => q#/\boperat(?:e|ing)\b[^.]{0,99}\b(?:for(?:ei|ie)gn|off-? ?shore|over-? ?seas?) (?:bank )?accounts?\b/i#,
  q#__FRAUD_JYG,[l=1]# => q#/\bgive\s+you .{0,15}(?:fund|money|total|sum|contact|percent)\b/i#,
  q#__FRAUD_KJV,[l=0]# => q#/(?:claim|concerning) (?:the|this) money/i#,
  q#__FRAUD_LTX,[l=1]# => q#/\bmilli?on (?:.{1,25} thousand\s*)?(?:(?:united states|u\.?s\.?) dollars|(?i:U\.?S\.?D?))\b/i#,
  q#__FRAUD_MCQ,[l=1]# => q#/\btransaction\b.{1,30}\b(?:magnitude|diplomatic|strict|absolute|secret|confiden(?:tial|ce)|guarantee)/i#,
  q#__FRAUD_MLY,[l=1]# => q#/\b(?:reply|respond)\b[^.]{0,50}\b(?:to|through)\b[^.]{0,50}\@\b/i#,
  q#__FRAUD_MQO,[l=0]# => q#/foreign (?:business partner|customer)/i#,
  q#__FRAUD_NEB,[l=0]# => q#/(?:government|bank) of nigeria/i#,
  q#__FRAUD_NRG,[l=0]# => q#/i am contacting you/i#,
  q#__FRAUD_PTS,[l=1]# => q#/\b(?:ass?ass?inat(?:ed|ion)|murder(?:e?d)?|kill(?:ed|ing)\b[^.]{0,99}\b(?:war veterans|rebels?))\b/i#,
  q#__FRAUD_PTX,[l=1]# => q#/\b(?:ass?ass?inat(?:ed|ion)|murder(?:e?d)?|poison(?:e?d)?|kill(?:ed|ing|ers)\b[^.]{0,99}\b(?:war veterans|rebels?)|les tueurs)\b/i#,
  q#__FRAUD_PVN,[l=0]# => q#/as the beneficiary/i#,
  q#__FRAUD_QFY,[l=1]# => q#/\bover-? *(?:invoiced?|cost(?:s|ing)?)\b/i#,
  q#__FRAUD_QXX,[l=1]# => q#/\b(?:my name is|i am) (?:mrs?|engr|barrister|dr|prince(?:ss)?)[. ]/i#,
  q#__FRAUD_RLX,[l=1]# => q#/lott(?:o|ery) (?:co,?ordinator|international)/i#,
  q#__FRAUD_SNT,[l=1]# => q#/\blocate(?: .{1,20})? extended relative/i#,
  q#__FRAUD_TCC,[l=0]# => q#/foreign (?:offshore )?(?:bank|account)/i#,
  q#__FRAUD_TDP,[l=1]# => q#/\b(?:business partner(?:s|ship)?|silent partner(?:s|ship)?)\b/i#,
  q#__FRAUD_THJ,[l=0]# => q#/modalit(?:y|ies)/i#,
  q#__FRAUD_ULK,[l=1]# => q#/\baffidavits?\b/i#,
  q#__FRAUD_UOQ,[l=0]# => q#/vital documents/i#,
  q#__FRAUD_UUY,[l=1]# => q#/\blegitimate business(?:es)?\b/i#,
  q#__FRAUD_WDR,[l=1]# => q#/\bprivate lawyer\b/i#,
  q#__FRAUD_WFC,[l=1]# => q#/\bsecur(?:e|ing) (?:the )?(?:funds?|monies)\b/i#,
  q#__FRAUD_WNY,[l=1]# => q#/\b(?:disburse?(?:ment)?|incurr?(?:ed)?|remunerr?at(?:ed?|ion)|remm?itt?(?:ed|ance|ing)?)\b/i#,
  q#__FRAUD_XJR,[l=0]# => q#/(?:who was a|as a|an? honest|you being a|to any) foreigner/i#,
  q#__FRAUD_XVW,[l=1]# => q#/\bhonest cooperation\b/i#,
  q#__FRAUD_XWW,[l=1]# => q#/\b(?:honest(?:ly)?\sco(?:-?operat(?:e|ion)|llaborat(?:e|ion))|ehrliche\szusammenarbeit|sichere [kc]o+p[eo]ration|col+aboration\swith\sme)\b/i#,
  q#__FRAUD_YJA,[l=0]# => q#/over-invoice/i#,
  q#__FRAUD_YPO,[l=0]# => q#/the total sum/i#,
  q#__FRAUD_YQV,[l=0]# => q#/nigerian? (?:national|government)/i#,
  q#__FRAUD_YWW,[l=1]# => q#/\bfurnish you with\b/i#,
  q#__FRAUD_ZFJ,[l=1]# => q#/\b(?:wife|son|brother|daughter) of the late\b/i#,
  q#__GAPPY_SALES_LEADS,[l=1]# => q#/\b(?:business|e?-?mail|your|marketing|advertising)\s(?!sales|leads|campaign)(?:s\s?a\s?l\s?e\s?s|l\s?e\s?a\s?d\s?s|c\s?a\s?m\s?p\s?a\s?i\s?g\s?n)\b/i#,
  q#__GHANA,[l=1]# => q#/\bghana\b/i#,
  q#__HAS_WON_01,[l=1]# => q#/\bque ha ganado\b/i#,
  q#__HK_LOTTO_1,[l=1]# => q#/\b(?:(?:inter)?national|foundation|mercato|univers|euro ?million|e-?mail|euro-pw|bill ?gates|swiss|prestige|cristal|am.ricaine|coca.?cola|fiduciary|department) ?lot(?:eri[ej]|t(?:ery|o))/i#,
  q#__HK_LOTTO_2,[l=1]# => q#/\blot(?:eri[ej]|t(?:ery|o)) ?(?:(?:inter)?national|foundation|mercato|univers|euro ?million|e-?mail|euro-pw|bill ?gates|swiss|prestige|cristal|am.ricaine|coca.?cola|fiduciary|department)/i#,
  q#__HK_LOTTO_BALLOT,[l=1]# => q#/\b(?:promotional|on.?line|computer|internet|e-?mail|fran.aise) (?:ballot|draw|sweepstake)/i#,
  q#__HK_LOTTO_JACKPOT,[l=1]# => q#/\bmega jackpot\b/i#,
  q#__HK_LOTTO_STAATS,[l=1]# => q#/\bstaatsloteri/i#,
  q#__HUSH_HUSH,[l=1]# => q#/\b(?:confiden[tc]i[ae]l(?:\b|ity\b|it(?:=E9|[\xe9]|[\xc3][\xa9]))|private\b|secr[e\xe8](?:te?|cy)\b|sensitive\b|concealed\b|obscured?\b|discre(?:et|tion)\b|very\sdiscrete|top\ssecret|vertraulich(?:en)?\b|geheim\b|priv(?:e|=E9|[\xe9]|[\xc3][\xa9]))/i#,
  q#__IMH_PHISH_BODY,[l=1]# => q#/\/[a-zA-Z]+\.php\?[a-zA-Z0-9]*\=3D/#,
  q#__INHERIT_PMT,[l=1]# => q#/\binheritance\spayment\s/i#,
  q#__INTL_BANK,[l=1]# => q#/\b(?:international\s(?:\w+\s)?bank|banque\sinternationale)\b/i#,
  q#__INVEST_COUNTRY,[l=1]# => q#/\binvest\sin\syour?\scountry\b/i#,
  q#__INVEST_MONEY,[l=1]# => q#/\binvest(?:ir)?\s(?:this|ces|d[ae]s|sur ce|de ces)\s(?:money|f[ou]nds?)\b/i#,
  q#__ISO_2022_JP_DELIM,[l=1]# => q#/\e\$B/#,
  q#__IVORY_COAST,[l=1]# => q#/\b(?:Cote\s?D.Ivoire|Ivory\s?Coast|Costa\sde\sMarfil)\b/i#,
  q#__I_INHERIT,[l=1]# => q#/\b(?:I|eu)\s[a-z\s]{0,30}(?:inherited|herdei)\b/i#,
  q#__I_WILL_YOU,[l=1]# => q#/\bwill(?:ed)?\s(?:[a-z\s]{0,20}(?:fortune|money|\$[\d,]+[a-z]{0,9})\s)?to\syou\b/i#,
  q#__JAPANESE_UCE_BODY,[l=1]# => q#/(?:L\$>5Bz|EE;R%a!<%k)(?:8x|9-)9p/#,
  q#__JMQ_DROPBOX3,[l=1]# => q#/ach.(payment|transfer)/i#,
  q#__JMQ_HEARINGLOSS3,[l=1]# => q#/going.crazy|natural.formula|restore.your.hearing|click.here.to.see|off.hearing.aid/i#,
  q#__JMQ_IMPORTANT2,[l=0]# => q#/important message/i#,
  q#__JMQ_IMPORTANT3,[l=0]# => q#/please visit/i#,
  q#__JMQ_PICKUP2,[l=1]# => q#/(dirty|freaky|naughty|good)(pix|pic)|hey.cutie/i#,
  q#__JMQ_PICKUP4,[l=1]# => q#/\d+.year.old|female/i#,
  q#__JMQ_REALESTATE3,[l=1]# => q#/preferred.choice|looking.for.real.estate|online.platform|systems.placement/i#,
  q#__JMQ_RESUME2,[l=0]# => q#/hello my name|my name is/i#,
  q#__JMQ_RESUME3,[l=1]# => q#/appreciate.your.cooperation|my.resume.is.pdf|resume.attach|pdf.file.is|is.my.resume/i#,
  q#__JMQ_TRACKR3,[l=1]# => q#/locate anything|find.anything|never.lose.anything|new.invention|never.lose.your|tired.of.losing|find.any.lost/i#,
  q#__JMQ_WIRE2,[l=1]# => q#/medical.support|payment.sent/i#,
  q#__JMQ_WIRE3,[l=1]# => q#/bank.wire|sent.out.asap/i#,
  q#__KAM_1LINE1,[l=1]# => q#/(free score and report|Did you overpay\?)/is#,
  q#__KAM_ABOUT2,[l=0]# => q#/Spyware/i#,
  q#__KAM_ACCOUNTPHISH3,[l=1]# => q#/update.your.information|problems.with.your|billing.information|order.details|personal.data|detailed.order|order.information|for.activation|account.{1,30}.inactive|information.required|secure.browser|recently.compromised|classified.document|with.your.email|complete.your.account|account.confirmed|claim.your.order|free.money|forced.to.cancel|immediate.access|upgrading.all.staff|advice.to.update|confirm.your.account/i#,
  q#__KAM_ACCOUNTPHISH4,[l=1]# => q#/webmail|all.systems|storage.limit|get.back.into|update.your.account|kindly.click|very.private.message|this.is.honest|fill.the.form|click.on.send|follow.here|for.all.user|one.click.away|mail.desk/i#,
  q#__KAM_ACNE3,[l=0]# => q#/proactiv/i#,
  q#__KAM_ACNE4,[l=0]# => q#/Online Gift Rewards/i#,
  q#__KAM_ADHD3,[l=0]# => q#/struggling with adh?d|treatment options/i#,
  q#__KAM_ADVANCE2,[l=0]# => q#/Advance Details/i#,
  q#__KAM_ADVANCE3,[l=0]# => q#/Pre-Approved/i#,
  q#__KAM_ADVERT1,[l=1]# => q#/email advertising|\d{3}%.roi/is#,
  q#__KAM_ADVERT2,[l=1]# => q#/instant traffic (to your website|and sales)|demand.generation/is#,
  q#__KAM_ADVERT3,[l=1]# => q#/Email Ad Broadcast|Double OPT IN list|making.some.changes/is#,
  q#__KAM_ADVERTISE3,[l=1]# => q#/advertising.for.samsung|no.application.fee|carry.this.advert/i#,
  q#__KAM_ALARM2,[l=1]# => q#/free Quote|burglaries|wireless.security.camera|(Guard|protect) Your Family|ADT is Number One|monitored security system|install from ADT|with ADT security|keep(ing)?.your.home.safe|home.is.your.castle|sleep.with.security|home.security.system|remote.access|video.security/i#,
  q#__KAM_ALERT3,[l=0]# => q#/help button/i#,
  q#__KAM_ALT1,[l=1]# => q#/reply to my alternative E-?mail/is#,
  q#__KAM_ANA1,[l=1]# => q#/(anatrim|Green ?Tea|cortitherm|PHENTERTHIN|Phentremine|Acai Ultra|Civ-xR|WuYi Tea|Wu-?Yi Source|FRS Healthy Energy|Acai Berry|Chinese secret|Ephedra|Cholestapro|ColonMedic|Pure Cleanse|AcaiBurn|Acai Elite|Garcinia|Chlorogenic Acid|green coffee)/i#,
  q#__KAM_ANCESTOR3,[l=1]# => q#/family.history|your family|share.the.stories/i#,
  q#__KAM_ANDROGEL3,[l=1]# => q#/healthcare|medwatch|drug|testosterone|therapy|manhood|your.woman/i#,
  q#__KAM_AP3,[l=0]# => q#/American Grants and Loans Catalog/i#,
  q#__KAM_AQUA1,[l=1]# => q#/Aqua Globe/is#,
  q#__KAM_AQUA2,[l=1]# => q#/watering your plants/is#,
  q#__KAM_AQUA3,[l=1]# => q#/while on vacation/is#,
  q#__KAM_AQUARUG3,[l=1]# => q#/stop.slipping|unique.carpet|aqua.rug|bare.feet.love/i#,
  q#__KAM_ARREST2,[l=1]# => q#/Instant Checkmate|dirty Truth|\brapist\b|criminal.(background|record)|predator|stay.safe|child.offender|think.you.know|know.everything|database.screening|know.something|wanted.to.know|arrest.record/i#,
  q#__KAM_ASIAN2,[l=0]# => q#/Adoring Asian/i#,
  q#__KAM_ASSASSIN2,[l=0]# => q#/my identity/i#,
  q#__KAM_ASSASSIN3,[l=0]# => q#/assassinate/i#,
  q#__KAM_ASSASSIN4,[l=1]# => q#/like.an.accident/i#,
  q#__KAM_ATTORNEY3,[l=1]# => q#/find.a.\b[a-z]+\b.attorney/i#,
  q#__KAM_AUGER2,[l=0]# => q#/Awesome Auger/i#,
  q#__KAM_AUTO3,[l=1]# => q#/(car|truck).dealer|clearance.price|shop.cars|\d+.vehicles|dealership|deep.discount|liquidating|vehicle.options|auto.news|old.clunker|dream.car|clearance.inventory|dealer.clearance|special.clearance|auto(mobile?).recall|clearance.pric|new.ride|dealers.{1,40}.scrambling|sell.yours.for.more|car.is.worth|auto.parts.brand|blowout|incredible.discount/i#,
  q#__KAM_AUTONEW2,[l=1]# => q#/car.{1,2}insurance.{1,2}payment|monthly.payment|plan.has.expired|auto.loan|auto.coverage|coverage.benefits|premium.reduc|compare.quote|financing.your.way/i#,
  q#__KAM_AUTONEW3,[l=1]# => q#/just.{1,2}been.{1,2}lowered|reduced.recently|has been reduced|free.repair|easy.steps|overpaying|view.plan|overpaid.your|premiums?.as.low|lenders.compete/i#,
  q#__KAM_BACK1,[l=1]# => q#/backgrounds in seconds|Instant..?Checkmate|federal.record|background.report|criminal|reputation/i#,
  q#__KAM_BACK2,[l=1]# => q#/(Property & Personal history|Asset & Background) (Investigation|Search)|check anyone|know.anything|registered.offense|their.name|publicly.available/is#,
  q#__KAM_BACK3,[l=1]# => q#/(background check|detective|investigator|investigate backgrounds|arrest.record|public.record)|remain.anonymous|anonymous.report|says.about.you|instant.database|the.truth|reveal.the.information|screening.services/is#,
  q#__KAM_BACKUP3,[l=1]# => q#/backup.necessary|marketing|infographic|charge.more/i#,
  q#__KAM_BADUNSUB,[l=0]# => q#/(?:remove|Unsubscribe) from (?:MindTCommunications|LunarMessages)/i#,
  q#__KAM_BAD_REVIEW2,[l=0]# => q#/Reputation Giant/i#,
  q#__KAM_BARK1,[l=1]# => q#/Bark.Off|petzoom sonic|comfy control harness|dogs? behavior|four legged/i#,
  q#__KAM_BBB2,[l=1]# => q#/consumer's *(?:worry|uneasiness|anxiety|disturbance|concern|trouble)/i#,
  q#__KAM_BBB3,[l=0]# => q#/has been registered the above|(?:visiting|review at) a link below|above-referenced complaint/i#,
  q#__KAM_BBB4,[l=1]# => q#/about your *(?:glance|belief|judgment)/i#,
  q#__KAM_BEAUTY1,[l=1]# => q#/she now looks \d+/i#,
  q#__KAM_BEAUTY2,[l=0]# => q#/reveals exactly/i#,
  q#__KAM_BEAUTY3,[l=0]# => q#/most amazing transformation/i#,
  q#__KAM_BITCOIN2,[l=1]# => q#/price.of.bitcoin|bitcoin.price|crypto.?currenc(y|ies)|currency.pioneer|cartel|financial.security|abandoned.our.dollar|money.map/i#,
  q#__KAM_BIZ1,[l=1]# => q#/You always need new cards|free full color business cards|get 250 more ?- ?free|business card offer|500 business cards/is#,
  q#__KAM_BLOOD3,[l=1]# => q#/Secret Big Pharma|conspiracy|Breaking.Health.Stories/i#,
  q#__KAM_BLOOD4,[l=1]# => q#/Marine Essentials|this mineral|drug.companies.hate/i#,
  q#__KAM_BLOOD5,[l=1]# => q#/Anti-Aging Expert|worst.food/i#,
  q#__KAM_BLOOD6,[l=0]# => q#/Blood pressure/i#,
  q#__KAM_BOXQUOTA,[l=1]# => q#/mailbox.{0,5}exceeded.{4,14}quota/i#,
  q#__KAM_BOXVERIFY,[l=1]# => q#/Verify.{0,10}Mail.?box/i#,
  q#__KAM_BUS1,[l=0]# => q#/business proposal/i#,
  q#__KAM_BUS2,[l=0]# => q#/sensitive by nature/i#,
  q#__KAM_BUS3,[l=0]# => q#/have not met/i#,
  q#__KAM_BUS4,[l=0]# => q#/view my attach/i#,
  q#__KAM_BUSINESSPHONE3,[l=0]# => q#/business phone system/i#,
  q#__KAM_CAD2,[l=1]# => q#/we.specialize.in/i#,
  q#__KAM_CAD3,[l=1]# => q#/our.products/i#,
  q#__KAM_CANDY3,[l=0]# => q#/you deserve a treat|sweet tooth/i#,
  q#__KAM_CAR2,[l=0]# => q#/buying a new car|dream car|new car you want|free auto insurance(?:-| )quote|save money on your auto|roadside assistance|extended warranty/i#,
  q#__KAM_CAR3,[l=1]# => q#/unbelievable payment terms|no commitment|free price quote|get competitive quotes|offering better rates|no obligation quote|Pay Later|No risk|save up to \d+%/i#,
  q#__KAM_CARD2,[l=1]# => q#/(laughing kitty|crazy cat) card|enjoy your awesome card|Click on your .{0,15}card('s)? (link|direct www address) below|To see your custom .{0,15}card, simply click on the (link below|following)|(as you can see on the ecard)|^your .{1,15}card link:$|I bet your wife won\'?t do this for you|Your temporary Login Info|temp\.? password id|pics I took of my Ex-Wife|card will be aviailable|our.new.collection/i#,
  q#__KAM_CARD3,[l=1]# => q#/I['`]m in hurry, but i still love you...|has (issued you a greeting|made you an Ecard)|^(Follow this link:|click (here to enter our secure server:))?\s*?http:\/\/\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}|eCard, open attached/i#,
  q#__KAM_CARDEAL3,[l=1]# => q#/201\d Closeout pricing|New Vehicles near you|new automobiles|brand new car|\d{4} makes and models/i#,
  q#__KAM_CAREER1,[l=1]# => q#/Hospitals need you|Medical Billing and Coding|medical.coding/is#,
  q#__KAM_CAREER2,[l=1]# => q#/Get your Healthcare Degree|Billing and Coding degree|job.placement|great.opportunity|training.start(s|ing).soon|job.growth/is#,
  q#__KAM_CAREER3,[l=1]# => q#/unstable.economy|secure.a.position|fast.growing|extraordinary.benefits|work.from.home/is#,
  q#__KAM_CASINO1,[l=0]# => q#/Elite World Casino/i#,
  q#__KAM_CASINO2,[l=0]# => q#/Online Casino/i#,
  q#__KAM_CELL3,[l=1]# => q#/phone.(information|deals|reviews)|(free|latest|hottest)..?(cell)?.?phone|selection.of.phones|hottest.(brands|models)|check.out.these.smartphones|smartphones.do.more|refurbished.phone|bored.with.your.phone/i#,
  q#__KAM_CEP1,[l=1]# => q#/Job Prospect Newsletter|training.workshop/i#,
  q#__KAM_CEP2,[l=1]# => q#/legitimate verifiable degree|build a better you|domain.knowledge/i#,
  q#__KAM_CEP3,[l=1]# => q#/Career Education program|customize a learning program|certified.instructor/i#,
  q#__KAM_CEP4,[l=1]# => q#/(MBA|CEP)/#,
  q#__KAM_CEP5,[l=0]# => q#/degree\/certificates|certification/i#,
  q#__KAM_CEP6,[l=1]# => q#/\d (week|month)/i#,
  q#__KAM_CHANGELOG2,[l=0]# => q#/as promised chnglog update/i#,
  q#__KAM_CHECK1,[l=0]# => q#/delivery fee for your che(que|ck) draft/i#,
  q#__KAM_CHECK2,[l=0]# => q#/let me know when you recieve your money/i#,
  q#__KAM_CHICKEN3,[l=1]# => q#/your.own.chicken|fresh.egg|chicken.coop|build.your.own/i#,
  q#__KAM_CHOSEN3,[l=1]# => q#/You (were|have been|are) (recently )?(chosen|invited)|you.are.(very.)?welcome/i#,
  q#__KAM_CIGAR3,[l=0]# => q#/Thompson Cigar|Premium Cigar/i#,
  q#__KAM_CLAIMS3,[l=1]# => q#/claim.payment|claim.processing|kindly.confirm/i#,
  q#__KAM_CLICK,[l=0]# => q#/Please click on the link below|Copy and paste this link into your internet browser/i#,
  q#__KAM_CLOUD3,[l=1]# => q#/big data|powering apps|reduce.tech.costs|backup.solution|bundling.the.service/i#,
  q#__KAM_CLOUD4,[l=1]# => q#/hacking|complimentary.(lunch|breakfast)/i#,
  q#__KAM_COBRA3,[l=0]# => q#/find cobra health/i#,
  q#__KAM_COLLECT2,[l=0]# => q#/No Fee/i#,
  q#__KAM_COLLECT3,[l=0]# => q#/collection professionals/i#,
  q#__KAM_COLLECT4,[l=0]# => q#/recovery rate/i#,
  q#__KAM_COMPANY2_1,[l=1]# => q#/Member Services MGM, LLC/is#,
  q#__KAM_COMPROMISED3,[l=1]# => q#/\d{1,2}[\\\/]\d{1,2}[\\\/]\d{2,4} \d{1,2}\:\d{1,2}\:\d{1,2} (AM|PM)/#,
  q#__KAM_COMPROMISED4,[l=1]# => q#/How are you\? Look at this.{0,70}Do you know about this site|look at this site right now|I found (an amazing|great) site|hey\. please have a look|have a look right now|breaking news/i#,
  q#__KAM_CONTACTME2,[l=0]# => q#/read the attached letter/i#,
  q#__KAM_CONTRACT3,[l=0]# => q#/buy you out|service management|management solution/i#,
  q#__KAM_CREDIT2,[l=1]# => q#/View (all 3 reports|your credit score|your up.to.the.minute credit)|(EXPERIAN|Transunion|Equifax) report|check my credit score|3.free credit scores|credit restoration|changes in your.score|get your \d+ score online|3 major sources|all three bureau|all 3 credit score|credit (may )?ha(ve|s) been revised|payment.options|complimentary 3 scores|credit scores? in seconds|TRANSUNION,\s+EQUIFAX,\s+(and|.)\s+EXPERIAN|just (been )?changed|score.breakdown|credit.summary|score.is.waiting|confirmation [hash]\d+|average.credit.score|what.?s.your.score|(3|three).free.score|check.your.score|we.can.help|credit.record|complimentary.score/i#,
  q#__KAM_CREDIT3,[l=1]# => q#/NO COST|it's on us|3 companies for free|freescore360|Scoresense|score.report(?:ing)?.team|stand in the rating scales|view your higher credit|(score|credit).alert|provide.faster.service|your credit score|free.credit.score|score.generation|new.score.immediately|score.notification|your report/i#,
  q#__KAM_CREDIT4,[l=1]# => q#/CHANGES TO YOUR CREDIT[- ]SCORE|credit score has changed|Triple Bureau Credit Alerts|score\s+may\s+have\s+(been)?\s*changed|ThinkCredit|Debunk Credit Card Processing Myths|costs for your business|TransUnion,? Experian and Equifax Scores|ha(s|ve).been.updated|what.?s.your.credit|sensitive.information/i#,
  q#__KAM_CRIM1,[l=0]# => q#/(group|team) of (hackers|web criminals)|(eliminate|destroy) (the|this) (videotape|evidence|promising evidence)|complain to the cops/i#,
  q#__KAM_CRIM2,[l=1]# => q#/(bitcoin|BTC|bitcоi)/#,
  q#__KAM_CRIM3,[l=1]# => q#/make a payment|have to pay|finish a transaction|transfer me \d+ euro|use my bitcoin wall|BTC wallet|BTC cryptocurrency/i#,
  q#__KAM_CRIM4,[l=0]# => q#/porn|compromising evidence|masturb|playing with yourself|wanking/i#,
  q#__KAM_CRIM5,[l=1]# => q#/(twenty.?four|24).?hours|(24|32|12) h\. (since|from) (now|this moment)|one day after opening|tracking pixel/i#,
  q#__KAM_CRYPTO1,[l=1]# => q#/swiss.?coin|[{(]SIC[)}]/i#,
  q#__KAM_DATINGTIPS3,[l=1]# => q#/seduction|certain.type.of.guy|secret to their hearts|women.excited|real.love|one.night.stand/i#,
  q#__KAM_DEALS3,[l=1]# => q#/exclusive.savings/i#,
  q#__KAM_DEATH1,[l=1]# => q#/prevent early.death/i#,
  q#__KAM_DEATH3,[l=1]# => q#/Eating this|before it.?s too late/i#,
  q#__KAM_DEATH4,[l=1]# => q#/heart.(attack|stops)/i#,
  q#__KAM_DEATHINSURE3,[l=1]# => q#/inheritance.tax|your.loved.ones|funeral.costs/i#,
  q#__KAM_DEBT1,[l=1]# => q#/(debts disappear|reduce your payments|piling bills|creditors|late bills|vanish some of your bills|reduce your payments|looming bills|all that debt|outstanding debt|debt.{0,7}accumulated|all my debt|penalties,? and fees are gone|banking laws|select legal|change your life|get out of .?d.?e.?b.?t|Free[- ]Credit Report|debt relief options|are you in debt|pay off all your debt|get better rates|credit card debt|could.be.easy)/is#,
  q#__KAM_DENTIST3,[l=0]# => q#/Find a dentist/i#,
  q#__KAM_DETOX3,[l=1]# => q#/detox.program|right.for.you|clean(ing)? up your life|a.little.easier/i#,
  q#__KAM_DIABETES1,[l=1]# => q#/- - Diabetes News Today - -|diabetes.health|blood.sugar/i#,
  q#__KAM_DIABETES2,[l=1]# => q#/Reverse.{0,10}(Diabetes|type.2|type.1)|reverse.type.2|beat.type.2|conventional.medical/i#,
  q#__KAM_DIET2_3,[l=1]# => q#/secret to being skinny|doctors? are raving|testosterone|could be \d+ ?lbs? lighter|feeling chubby/i#,
  q#__KAM_DIRECT3,[l=0]# => q#/(Complimentary|Visitor|attend our open house|30-day member|VIP Pass|Wholesale Direct Pricing|guest pass and catalog)/i#,
  q#__KAM_DIRECT4,[l=1]# => q#/Direct.?Buy/i#,
  q#__KAM_DISCAIR3,[l=0]# => q#/Fly Cheap in Business Class/i#,
  q#__KAM_DISCLAIMER1,[l=0]# => q#/receives compensation/i#,
  q#__KAM_DOMAIN1,[l=1]# => q#/Domain (opportunity|notification|release|Availability|club)|Notification for Domain|availability.notice|time.draws.near|submit.a.bid|your.business|exclusive.rights|free.registration|the.domain.provider|website.wizard|increase.your.{0,50}.traffic|domain.extension|brand.can.leverage|like.to.obtain|buy(ing)?.this.domain/i#,
  q#__KAM_DOMAIN2,[l=1]# => q#/(?:available|listed) (?:by|for|at|in) auction|confirm interest in (this domain|owning)|capturing this domain|proposal.on.the.domain|exclusive.owner|online.search|web.form|counting.down|potential.buyer|interested.parties|secure.{1,50}.today|drive.more.leads|targeted.traffic|similar.domain|exclusive.regis/i#,
  q#__KAM_DOMAIN3,[l=1]# => q#/(?:have|own) a domain (that is )?.{0,5}similar|(have|own) a similar domain|offer on the Domain|similar to your (current )?domain|Domain Division|all.domains|main.webpage|visibility.platform|solicitation|potential.owner|your.offer|domain.match|domain.notification|domain.will.be|interest.{1,20}.domain.name|fully.responsive|website.included|list.your.website|opportt?unity.regarding|courtesy.notification/i#,
  q#__KAM_DOMAIN_SALE1,[l=1]# => q#/\b(related|similar) domain\b/i#,
  q#__KAM_DOMAIN_SALE2,[l=1]# => q#/\b(interested in|obtaining) .{5,20} domain\b/i#,
  q#__KAM_DOMAIN_SALE3,[l=1]# => q#/\bdomain (name owner|advanced avail|backordering)\b/i#,
  q#__KAM_DOMAIN_SALE4,[l=1]# => q#/\b(domain you might be interested|interested in the domain|interested in obtain|benefit acquiring|complete ownership transfer|brokering the domain)\b/i#,
  q#__KAM_DON3,[l=1]# => q#/donnob\.(?:biz|net)|emarketnow.com|watersolutiontoday.com/i#,
  q#__KAM_DON4,[l=0]# => q#/\$1,000 A Day ATM|J\.O\.B\./i#,
  q#__KAM_DRAPES3,[l=1]# => q#/banner.stand|print.project/i#,
  q#__KAM_DRILL1,[l=0]# => q#/drilling/i#,
  q#__KAM_DRILL2,[l=0]# => q#/oil (company|partnership|and gas rights)/i#,
  q#__KAM_DRILL3,[l=1]# => q#/(exceed(ed)? .{0,10}expectations|see your brokers website)/i#,
  q#__KAM_DRILL4,[l=0]# => q#/(buy today|Check this deal out)/i#,
  q#__KAM_DRIVE3,[l=1]# => q#/to.be.furnished|office.equipment.item/i#,
  q#__KAM_DROPBOX3,[l=1]# => q#/shared.a.folder/i#,
  q#__KAM_DRUG1,[l=1]# => q#/Quality and cheap|premier quality|supor-collosal mixture|Discount-?Pharmacy|hi.quality.drug/is#,
  q#__KAM_DRUG2,[l=1]# => q#/cheaper|redeem in bulk and save|bigger quantities and Save|drugstore accredi[dt]ations|economical (?:value|amount)|drug.online.supplies/is#,
  q#__KAM_DRUG2_3,[l=1]# => q#/Medi?cati[o0]ns|desired meds|favou?red (rx)?med|buy remedies|drug store|medicants|medicaments|sexual stim|sex stim|pain killer|(purchase|loved|preferred|favou?rite) (?:rx.?)?(deal|med)[sz]|rx.?Meds?.?deal|buy your meds|choice of meds|Rx.?(deal|Med|Sale)|v[i1]agra|medz.special|loved meds|(rx|medication) ?discount|Get the edge|joint.pain.relief|neuropathy|nerve.pain/i#,
  q#__KAM_DRUG2_4,[l=1]# => q#/grab hold|at[_ ~]your[_ ~]finger[_ ~]?tip|placing your order|questions about drugs|prescription is not|don't care about prescription|without a doctor|no need for a doctor|affor[df]able.prices|best daily rx|Fav.Prescript|unmatched.prices|rx.med|millions.are.praising/i#,
  q#__KAM_DRUG2_5,[l=1]# => q#/0nline|hassle[~-]free|favored rx|branded solutions|branded remedies|v[1i]cod[!i]n|Penhtremine|prxpills|ultimaterxhere|insanerx|speedymed4u|mightymeds1|coolestrxhere|hotrxmedspot|topshoprx|mightyrxhere|qualityrxmedz|legitrxlife|dealsformeds|simplyrxdeals|bestrxlight|ezprescriptz|reliablerxsource1|freetrusted-rx|hotmedsourcehere|CabinetOfMeds|mytrusted-rx|RxwarehouseHere|WarehouseofRxMeds|GreatrxMedsRus|rxmedsrus|(come by|Come to|Check Out) our web site|browse [0o]ur (website|selection)|Visit_0ur Web|Order_Now|available_this week|(buy|order) (n[0o]w|today|right.now|instantly|at [0o]nce|immediately)|check it out today|ord3r|0rder|0rd3r|browseour|rx ?unit/i#,
  q#__KAM_DRUG2_6,[l=1]# => q#/(Express|Prompt|Day|Trusty|Trustworthy|Reliable|fast|true|discreet|confidential|rapid)[_ ~\.]?Shippin|anonymous packing|shipped.right.away|adderrx|clinically.proven|support.formula/i#,
  q#__KAM_DRUG4,[l=1]# => q#/click to buy|no previous doctors direction|No prescript[oi]{2}n needed|no script necessary|medicine assistance supplier|mail[- ]?order medicine/is#,
  q#__KAM_DUCHESS3,[l=1]# => q#/Mr. Media Group|BLM Marketing Services|4801 l[yi]nton b/i#,
  q#__KAM_DUCHESS6,[l=0]# => q#/For account number:/i#,
  q#__KAM_DUTCHGLOW3,[l=1]# => q#/wood milk|dutch glow|wood's natural beauty|nourish wood|wax build up|your furniture|woodworking.plans/i#,
  q#__KAM_EBAY1,[l=0]# => q#/Succeed on ebay|thousands with ebay|ebay success|money-making secret/i#,
  q#__KAM_EBAY2,[l=0]# => q#/Auction success kit|Great Money Maker|documented program|Chuck Mullaney|more bills than money/i#,
  q#__KAM_EGG1,[l=1]# => q#/Egg Genie/is#,
  q#__KAM_EMAILPHISH1,[l=0]# => q#/Please login to complete update process/i#,
  q#__KAM_ENGINEER2,[l=1]# => q#/email.list|target.audience|databank|verified.email/i#,
  q#__KAM_ENGINEER3,[l=1]# => q#/construction.engineering|engineering . architect|marketing.manager/i#,
  q#__KAM_EPISODE,[l=1]# => q#/episode \d+/i#,
  q#__KAM_EVICTION3,[l=0]# => q#/eviction|foreclosed|trespasser/i#,
  q#__KAM_FAKEBBB2,[l=1]# => q#/(Fair Labor Standards Act|Safety and Health act|Better Business Bureau|(\b|$)BBB(\b|^))/i#,
  q#__KAM_FAKEBBB3,[l=0]# => q#/(complaint|compliant|Abuse) ID/i#,
  q#__KAM_FAKEBBB4,[l=1]# => q#/(incident:|case:)[\d:;]{6,}/i#,
  q#__KAM_FAKEDELIVER1,[l=1]# => q#/courier couldn.?t make the delivery|Courier was unable to deliver|courier company was not able to deliver|memo.of.application|delivering.address|make.the.delivery|see.attached.file|attention.please|event.invitation|could not deliver|delivery.label|postal.noti(fication|ce)|parcels.(has|have).been.shipped|shipment.label.is.attached/i#,
  q#__KAM_FAKEDELIVER11,[l=0]# => q#/DPD/i#,
  q#__KAM_FAKEDELIVER3,[l=1]# => q#/DHL/#,
  q#__KAM_FAKEDELIVER7,[l=0]# => q#/USPS/i#,
  q#__KAM_FAKEDELIVER9,[l=1]# => q#/CARGO/#,
  q#__KAM_FAKEPDF1,[l=1]# => q#/Download PDF Reader.Writer/is#,
  q#__KAM_FAKEPDF2,[l=1]# => q#/Reader 2010/is#,
  q#__KAM_FAKEVOUCHER2,[l=1]# => q#/\$\d+ amazon(.com)? Card|redeem.your.\$\d+|join.amazon|bonus voucher|spring.rewards|new.gift.card|exclusive.for|shopper.bucks|activate.here|cash.in.your/i#,
  q#__KAM_FAKEVOUCHER4,[l=1]# => q#/your.opinion|submit.your.email/i#,
  q#__KAM_FARM3,[l=0]# => q#/(blueberry|Tomatoe?) giant/i#,
  q#__KAM_FDA1,[l=1]# => q#/statements.{1,10}not.{1,10}evaluated.{1,10}(FDA|Food ?(and|&) ?Drug Administration)/i#,
  q#__KAM_FDA2,[l=1]# => q#/not intended to diagnose,? treat,? cure,? or prevent/i#,
  q#__KAM_FDA3,[l=0]# => q#/FDA Recall/i#,
  q#__KAM_FINGERHUT3,[l=1]# => q#/important.message|what.you.want|monthly.pay|your.account|credit.account|holiday.shopping|are.you.approved|fingerhut.buying/i#,
  q#__KAM_FLAG3,[l=1]# => q#/performance.flags|shopping.online|scoop on flags|need your flag|best flag|flag design|new flag|flag.needs|flags?.you.need/i#,
  q#__KAM_FLASH1,[l=1]# => q#/Flash Player Code: \d\d/i#,
  q#__KAM_FLASH2,[l=0]# => q#/Flash Player Update/i#,
  q#__KAM_FLEXHOSE3,[l=1]# => q#/stretch but not kink|flex.?hose|expanding.hose|garden.hose/i#,
  q#__KAM_FOOTBALL3,[l=0]# => q#/Mercato/i#,
  q#__KAM_FOOTBALL4,[l=0]# => q#/Football/i#,
  q#__KAM_FOUNTAINOFYOUTH3,[l=1]# => q#/look & feel old|\d+.years.of.aging|weird.\d+.second.trick/i#,
  q#__KAM_FRIEND2,[l=1]# => q#/wants.to.follow/i#,
  q#__KAM_FUNERAL3,[l=1]# => q#/untimely death|death notification|funeral.costs/i#,
  q#__KAM_GALLERY2,[l=1]# => q#/(?:Infinite|Multi|Elite|Extreme|Complete|Instant|Ultimate|Multi|approved|Free|HD|Guaranteed|Unreal) Access|(?:Ultimate|Babes|Elite|Extreme|P.?o.?r.?n) Collection|(?:Girls|Adu.?lt|Babes|Celeb.?rities) Passwords|(?:Ultimate|p.?o.?r.?n|extreme|elite|Girls) gallery|HD Video|Access Now/i#,
  q#__KAM_GALLERY4,[l=1]# => q#/(Fantastic|Insane|Mega|Extreme|Extreme|New|Many|Fresh|Your|Check) P.?o.?r.?n|cele.?brities elite|(Insane|P.?o.?r.?n|More|Awesome|All|Mega) Model|(Your|Mega|Asian|Bad|Cool|Fresh|Real|Awesome|More) Girl|(Sweet|Incredible|Insane|The|Grand) chick|(Many|New|Infinite|Cool|All) Cele.?b|The N.?u.?des|(Infinite|Awesome|Many|Sweet|Bad|Get|Fresh|Hot|More|Black) Babe|Amat.?e.?urs|(All|Fresh|Fantastic|The|Mega) Adu.?lt|(Extraordinary) Chicks/i#,
  q#__KAM_GARAGE3,[l=1]# => q#/surface protection plus|industrial strength|Concrete.{0,5}metal.{0,8}wood|protect.and.beautify|industrial.grade|common.flooring|treat.your.deck|professional.coating/i#,
  q#__KAM_GAS1,[l=1]# => q#/Gas prices are at an? all time high|\$\d per gallon|gasoline cards/i#,
  q#__KAM_GAS2,[l=1]# => q#/We have a solution|save \d+ cents per gallon|competitive rewards/i#,
  q#__KAM_GERMAN_BUSINESS_CONTACTS3,[l=0]# => q#/German business phone numbers/i#,
  q#__KAM_GERMAN_BUSINESS_CONTACTS4,[l=0]# => q#/Unlimited exportation capabilities/i#,
  q#__KAM_GEVALIA1,[l=1]# => q#/Gevalia Kaffe|premium coffee delivered/is#,
  q#__KAM_GEVALIA2,[l=1]# => q#/(Gevalia coffee lover's|I love coffee) kit/is#,
  q#__KAM_GEVALIA3,[l=1]# => q#/No Further Obligation/is#,
  q#__KAM_GIFT1,[l=1]# => q#/(Claim your free \$500 Target Gift Card|complimentary gift-?card|received a Victoria's Secret Giftcard|\$500 airline gift card|\$1000 gift card for you to shop|\$\d+.{0,50}gift card|Secret gift card)|costco.coupon|facebook.gift|claim.my.credit/is#,
  q#__KAM_GIFT2,[l=1]# => q#/(unsubscribe from this advertiseme(tn|nt)|exit future communications|to unsubscribe from this|to stop any offers from us)/is#,
  q#__KAM_GIFT3,[l=1]# => q#/every girl loves to buy|do you need a new|offer pass you by|shopping.online|best.price|activate.my|valued.{0,20}user|extra.deals|sign.up.today/i#,
  q#__KAM_GIFT4,[l=1]# => q#/card will be yours free|card on us|buy you the dyson animal|amazon.gift.?card|superstore|starbucks.card|card.egift|redeem.before|offering.you.this|enter.promo.code/i#,
  q#__KAM_GIFT5,[l=1]# => q#/member incentive program|complet(e|ing) the survey|your.customer.id|security.code|promotional.points/i#,
  q#__KAM_GIFTCERT1,[l=0]# => q#/Our gift to you/i#,
  q#__KAM_GIFTCERT2,[l=1]# => q#/\$\d+ gift certificate/i#,
  q#__KAM_GINA3,[l=0]# => q#/Genetic Information Nondiscrimination Act/i#,
  q#__KAM_GINA4,[l=0]# => q#/mandatory poster|remain in compliance|GINA regulations/i#,
  q#__KAM_GIRLS1,[l=0]# => q#/Lack of sex/i#,
  q#__KAM_GIVE1,[l=0]# => q#/receive your gift/i#,
  q#__KAM_GIVE2,[l=1]# => q#/laptop giveaway|deliver your dell.? laptop/i#,
  q#__KAM_GIVE3,[l=0]# => q#/answering a short survey/i#,
  q#__KAM_GIVE4,[l=0]# => q#/verify your shipping address/i#,
  q#__KAM_GOOGLE2,[l=0]# => q#/learn how to earn|automated income kit|online from home|as much money as you wish|be the boss/i#,
  q#__KAM_GOOGLE3,[l=1]# => q#/tons of money|making \$[\d,]*s with Google|extra cash|making serious money/i#,
  q#__KAM_GOOGLE4,[l=0]# => q#/with Google|Google Pie|Google Cash/i#,
  q#__KAM_GOOGLEPHISH1,[l=0]# => q#/copy of the signed agreement/i#,
  q#__KAM_GOOGLE_AWARD2,[l=0]# => q#/selected as a winner/i#,
  q#__KAM_GOOGLE_AWARD3,[l=0]# => q#/Dear Google/i#,
  q#__KAM_GOOGLE_AWARD4,[l=0]# => q#/Official Notification Letter/i#,
  q#__KAM_GOVT2,[l=0]# => q#/government funding/i#,
  q#__KAM_GOVT3,[l=0]# => q#/complimentary information kit/i#,
  q#__KAM_GOVT4,[l=1]# => q#/No.Money?.{0,4}No.Problem/i#,
  q#__KAM_GRANT1,[l=0]# => q#/government grant/i#,
  q#__KAM_GRANT2,[l=0]# => q#/find out if you qualify/i#,
  q#__KAM_GRANT3,[l=0]# => q#/discontinue from this promotion/i#,
  q#__KAM_GRASS3,[l=0]# => q#/Grass Seed On Steroids|rich beautiful lawn|Patch Perfect Seeds|Grow Grass (anywhere|in the shade)/i#,
  q#__KAM_GRIPPY3,[l=1]# => q#/gripeez.bonus|interior.decorator|sticky.grip/i#,
  q#__KAM_GUN1,[l=0]# => q#/Keep and Bear Arms/i#,
  q#__KAM_HAIRTRANS3,[l=1]# => q#/hair restoration|man look as young|losing your hair|hair ?loss|get.your.hair|(look|feel).younger/i#,
  q#__KAM_HANGOVER3,[l=0]# => q#/hangover patch/i#,
  q#__KAM_HAPPYTALK2,[l=1]# => q#/honest.and.nice/i#,
  q#__KAM_HAPPYTALK3,[l=1]# => q#/beautiful.mail/i#,
  q#__KAM_HEALTH1,[l=1]# => q#/as low as \$\d+\s*(per|\/)\s*month|at \$\d+ including dental/i#,
  q#__KAM_HEALTH2,[l=1]# => q#/save up to \d+% on health insurance|affordable health coverage|quality term life insurance|nationalhealthxchange.com|view.rate|no.obligation|start.saving/i#,
  q#__KAM_HEALTH2_1,[l=0]# => q#/affordable health coverage/i#,
  q#__KAM_HEART3,[l=1]# => q#/Knowing this could very well save your life|\d+.second trick|[hash]1 Trick|Prevent(ing)? A Heart Attack|will you be killed|heart disease|silent heart attack/i#,
  q#__KAM_HERPES3,[l=1]# => q#/permanent.remedy|ugly.sores|herpes.episode|got.herpes|your.herpes|herpes.issue/i#,
  q#__KAM_HIDDEN_URI1,[l=1]# => q#/\[DOT\]com/is#,
  q#__KAM_HIDDEN_URI2,[l=1]# => q#/replace "?\[DOT\]/is#,
  q#__KAM_HIP1,[l=0]# => q#/hip replacement|medical alert/i#,
  q#__KAM_HIP2,[l=0]# => q#/implant recall|recall list/i#,
  q#__KAM_HIRE3,[l=1]# => q#/hiring.situation|recruiting|plans.to.hire|altera.staff/i#,
  q#__KAM_HOLIDAY3,[l=0]# => q#/star special|Hotel Opening|(Request|order) a brochure/i#,
  q#__KAM_HOME1,[l=1]# => q#/YOUR HOME|Federal Housing Assistance Program|near.your.area/i#,
  q#__KAM_HOME2,[l=1]# => q#/Build your equity faster|refund is not reversible|rent.to.own/i#,
  q#__KAM_HOME3,[l=1]# => q#/tax saving plans|\d+K Mortgage Credit|no.more.of/i#,
  q#__KAM_HOMESALE3,[l=0]# => q#/Cash Offer for Your Home/i#,
  q#__KAM_HONOR1,[l=0]# => q#/greatest thing of your life/i#,
  q#__KAM_HONOR3,[l=0]# => q#/profession women/i#,
  q#__KAM_HONOR4,[l=0]# => q#/invitation/i#,
  q#__KAM_HOODIA3,[l=1]# => q#/(?:fat loss product|sur?p?press appetite|Reduce Your Appetite)/is#,
  q#__KAM_HOOKUP3,[l=1]# => q#/match.?me.?networks/i#,
  q#__KAM_HOSE3,[l=1]# => q#/pocket hose|garden.hose|stays.strong|grows.to.full.size|never.kinks/i#,
  q#__KAM_HOWRU2,[l=0]# => q#/My name is|what's your name|ask your name|keep company with you/i#,
  q#__KAM_HOWRU3,[l=0]# => q#/visit the site|visit this site|visiting this website|have some social networks|meet you in private|write me tomorrow/i#,
  q#__KAM_HOWRU4,[l=1]# => q#/gmx.com|rambler.ru/i#,
  q#__KAM_HSR1,[l=1]# => q#/hsrupdates.com|progressiverailroading.com/i#,
  q#__KAM_IDENTNET2,[l=0]# => q#/ADVERTISE WITH IDENTITY NETWORK/i#,
  q#__KAM_INK1,[l=1]# => q#/Ink (and|&|n) Toner|SimplyInk|101 inks|1ink|printer ink sale|full.price/is#,
  q#__KAM_INSTOCK,[l=0]# => q#/in stock/i#,
  q#__KAM_INSURE2,[l=1]# => q#/find better Health Insurance Rates Today|get information about health coverage|protect your family|overpay for auto insurance|been recently,? lowered|gas prices are going up|Auto Insurnace go with it|no examination|get (?:a )?free quote|have been.{0,2}reduced|AutoWarranty|plans as low as|plans starting at|complete your health profile|Secure \d+k coverage|growing.family|milestone|special.enroll|updated.rate|lifeinsurance|no.medical.exam|accuquote|no.tobacco.rate|denied.coverage|business.policy|reduced.rate|coverage.starts.immediately|obama|respect.your.privacy/i#,
  q#__KAM_INSURE4,[l=1]# => q#/why pay more for.{0,30}coverage|save up to \d+%|accuquote|Life Insurance Coverage|protect.your.family.{1,20}insurance|Protect home and belonging|Affordable Care Act|new health insurance plan for you|home.?.?protection|\d+k.life.insurance|eligible for auto.coverage|set to expire|\$\d+\/mo|new.rate|your.auto.?insurance.policy|term.life|update.policy|legacy|estate|your.package|your.own.life|prepared.for.anything|paying.(far.)?too/i#,
  q#__KAM_INTRUDE,[l=1]# => q#/\b(hope I am not intruding|out of the blue|I will never contact you again if you go here)\b/i#,
  q#__KAM_INVESTCOUNTRY2,[l=0]# => q#/invest in your country/i#,
  q#__KAM_INVOICE4,[l=1]# => q#/(billing error|problem with the address).{2,10}invoice/i#,
  q#__KAM_ITC2,[l=0]# => q#/International Trade Council/i#,
  q#__KAM_ITC3,[l=0]# => q#/enclosed/i#,
  q#__KAM_JESUS1,[l=1]# => q#/jesus lovely|the.lord|touched.by.christ/i#,
  q#__KAM_JESUS2,[l=1]# => q#/sister.in.the.lord|need for bible/i#,
  q#__KAM_JESUS3,[l=1]# => q#/nigeria|muslim.women/i#,
  q#__KAM_JOB1,[l=1]# => q#/let go from (a job|my employment) I held for.{1,19} (month|year|forever|life)/is#,
  q#__KAM_JOB2,[l=1]# => q#/twice as much/is#,
  q#__KAM_JOINT3,[l=1]# => q#/TFX.?(?:health|flex)|tflex/i#,
  q#__KAM_JOINT4,[l=0]# => q#/Joint Relief|effective as glucosamine/i#,
  q#__KAM_JOINT5,[l=0]# => q#/free bottle/i#,
  q#__KAM_JUDGE1,[l=1]# => q#/(unpaid court|(un-?collected|unsatisfied) judgments)/is#,
  q#__KAM_JUDGE2,[l=1]# => q#/(funds|receive what) you are (due|owed)/is#,
  q#__KAM_JUDGE3,[l=1]# => q#/collect your money/is#,
  q#__KAM_JUDGE4,[l=0]# => q#/judgment/i#,
  q#__KAM_JURY4,[l=1]# => q#/in Court|hearing date|notice to appear|Pretrial notice|compulsory.attendance|court.notice/i#,
  q#__KAM_KITCHEN3,[l=1]# => q#/special.gift|kitchen.remodel|special.offer/i#,
  q#__KAM_KIWIBANK3,[l=1]# => q#/security.procedure|customer.safety|security.details/i#,
  q#__KAM_KORS3,[l=0]# => q#/sent you this item|register to receive|latest updates|win great prizes|shop michael kors|kors insider|handbag collection/i#,
  q#__KAM_LANDSCAPE3,[l=1]# => q#/landscape.designs|(simple|cheap).strategies|design.troph/i#,
  q#__KAM_LANDSCAPE4,[l=1]# => q#/stone.carving/i#,
  q#__KAM_LANG3,[l=1]# => q#/pimsleur|Language in just \d+ Day/i#,
  q#__KAM_LASIK3,[l=1]# => q#/free (?:Lasik )?eval|\d+ per eye|get lasik info|L.SI. V....n In.t.tut. Summ.r S.v.ng.|works.faster.than/i#,
  q#__KAM_LED2,[l=0]# => q#/solar (lighting|led)/i#,
  q#__KAM_LED3,[l=0]# => q#/China aier/i#,
  q#__KAM_LENS1,[l=0]# => q#/pro quality (pho|pic)|Bill gates|best camera/i#,
  q#__KAM_LENS3,[l=0]# => q#/amazing lens|hdx-lens|hdrx/i#,
  q#__KAM_LIKE1,[l=1]# => q#/been working (extremely|very) hard on my friend's website/is#,
  q#__KAM_LIKE2,[l=1]# => q#/a link from .{1,54} would be greatly appreciated/is#,
  q#__KAM_LIKE3,[l=1]# => q#/(link exchange|in return to me linking back)/is#,
  q#__KAM_LIKE4,[l=1]# => q#/HTML code for the link/is#,
  q#__KAM_LIKE5,[l=1]# => q#/I apologize if this message was sent, in error/is#,
  q#__KAM_LINGERIE4,[l=0]# => q#/Exotic modelling videos/i#,
  q#__KAM_LIST1,[l=1]# => q#/((Hospital|MD) directory|Nursing Home (List|directory)|doctor lists|marketing lists|Licensed Physicians|practicing MDs|practicing Medical doctors|Physicians in America|emails for every state|(vip|laywers|planners|Business Email|HR Directors Email|Sales & Marketing Directors|Managing Director Email) database)/is#,
  q#__KAM_LIST2,[l=1]# => q#/(?:hospital|dentist|chiropractor|physician|medical doctors|nursing directors|medical marketing|\d sortable fields|records all with emails|business director(y|ies)|direct marketing data)|nursing assistant/is#,
  q#__KAM_LIST3,[l=1]# => q#/price\:|prices for our director/is#,
  q#__KAM_LIST4,[l=1]# => q#/(?:database|list|[\d,]+ (total records|e-?mails))/is#,
  q#__KAM_LIST5,[l=1]# => q#/(reply with "stop" as a subject|Send an email with "rem" in the subject to discontinue|put "cease" in the subject of an email|for termination of this e?mail|reply with .{1,8} in the subject)|you will have your email taken off|for the datacard|send.a.reply/is#,
  q#__KAM_LOAN3,[l=1]# => q#/Financial Relief|need to borrow|Business Loan|instant.funds|approval department|\$\d+ down|loan option|offer.loan|expenses|times.are.tough|money.problems/i#,
  q#__KAM_LOAN4,[l=1]# => q#/development.project|just.been.approved|for.your.business|loan.solution/i#,
  q#__KAM_LOGO1,[l=1]# => q#/guru.level logo/i#,
  q#__KAM_LOGO3,[l=1]# => q#/(guru.level|ready.made) logo/i#,
  q#__KAM_LOTTO2,[l=1]# => q#/((ticket|serial|lucky) number|secret pin ?code|pin number|batch number|reference number|promotion date|lottery|sweepstake|\d+ lucky recipients|for claim and inquiring)/is#,
  q#__KAM_LOTTO3,[l=1]# => q#/(won|claim|cash prize|pounds? sterling|over \$500|award sum of US\$|NOTIFICATION FOR CASH AID)/is#,
  q#__KAM_LOTTO4,[l=1]# => q#/(claims (office|agent|manager)|lottery coordinator|(certificate|fiduciary) (officer|agent)|fiduaciary claims|accredited agent|payment agency board|promotion manager|promotions? department|Name of +Agent:|executive secretary|claims & Management|lottery approved courier|promo.team)/is#,
  q#__KAM_LOTTO5,[l=1]# => q#/(POWERBALL LOTTO|freelotto group|Royal Heritage Lottery|(British|UK) National( Online)? Lottery|U\.?K\.? Grand Promotions|Lottery Department UK|Euromillion Loteria|Luckyday International Lottery|International Lottery|Euro - Afro Asian Sweepstake|urawinner|Free Lotto Sweepstakes|PROMOTION DEPARTMENT|PROMOTION\/PRIZE AWARD|Nederlandse Internationale Loterij|EURO MILLIONS|APPLE LOTTERY ONLINE|MSW MEGA JACKPOT|MICROSOFT EMAIL PROMO|MSNlottery|ECOWAS|Nigeria|National Lottery|claim.{1,10}your.gbp|won.you.{1,10}gbp)/is#,
  q#__KAM_LOTTO6,[l=1]# => q#/(Dear (Award|Consultation Prize|Lucky) Winner|Winning Notification|Attention:Winner|Dear:? Winner|Amount won:|Sincere Congratulations|Lucky Numbers:|you are a winner|prize attached|prize notification|claims requirement|winning number|winning sum|payout of|qualification number)|attached.file|numbers.on.email/is#,
  q#__KAM_LUNAR4,[l=1]# => q#/sleep you really need|sleep(ing)? aid|trouble.sleeping|miracle.sleep|lunar.?sleep|all.natural|fall.asleep|refreshed|sleep.cycle|sleep.aid|lack.of.sleep|stay.asleep|somnapure|weird.trick/i#,
  q#__KAM_MAID3,[l=1]# => q#/Pre-Screened Housekeepers|local.maid/i#,
  q#__KAM_MAILBOX1,[l=1]# => q#/mailbox has exceeded the storage limit|storage.quota/i#,
  q#__KAM_MAILBOX2,[l=0]# => q#/re-validate your (mailbox|email)/i#,
  q#__KAM_MAILER1,[l=0]# => q#/{!firstname_fix}/i#,
  q#__KAM_MARIJUANA1,[l=0]# => q#/marijuana|cannabis/i#,
  q#__KAM_MARIJUANA2,[l=1]# => q#/medicinal|recreational|legal.cannabis/i#,
  q#__KAM_MARIJUANA3,[l=1]# => q#/colorado|washington|profit|without.a.(prescription|doctor)|lets.you.vape|no.doctor/i#,
  q#__KAM_MASCARA3,[l=0]# => q#/smartlash/i#,
  q#__KAM_MED1,[l=1]# => q#/e.?c.?o.?n.?o.?m.?i.?z.?e.{1,10}med/i#,
  q#__KAM_MEDICAL1,[l=0]# => q#/million who suffer from|suffered from organ failure|Medical Billing and Coding|medical doctor/i#,
  q#__KAM_MEDICAL2,[l=0]# => q#/Safe - Natural - Effective/i#,
  q#__KAM_MEDICARE3,[l=1]# => q#/medicare.(plan|recipient)/i#,
  q#__KAM_MEDICARE4,[l=1]# => q#/over.(65|sixty.?five)|most.affordable|lower.your.premium/i#,
  q#__KAM_MEDTOUR1,[l=1]# => q#/medical.tourism/i#,
  q#__KAM_MEDTOUR2,[l=0]# => q#/lowest cost in India/i#,
  q#__KAM_MEMBER3,[l=1]# => q#/(\b|^)dating|eharmony|Find.Your.Perfect.Match|thousands.of.single.women|singles?.photos?|local.cougar|successfully matched|blind date|(available|black|latin[oa]|jewish).singles|photos of 50\+/i#,
  q#__KAM_MERCHANT2,[l=1]# => q#/business.owner|merchant.processor|processing.fee|average.bank|interchange.fee/i#,
  q#__KAM_MERCHANT3,[l=1]# => q#/merchant.processing|small.business|yearly.credit|monthly.fee|100%.free/i#,
  q#__KAM_MESH3,[l=0]# => q#/have a mesh implant|entitled to compensation|consumer injury|injured consumer/i#,
  q#__KAM_MILLIONAIRE1,[l=0]# => q#/internet millionai?re/i#,
  q#__KAM_MILLIONAIRE2,[l=0]# => q#/huge success stor(y|ies)|controversial/i#,
  q#__KAM_MM_FOREX_1,[l=1]# => q#/program.{0,10}ktory\ssam\sgra\sna\sgieldzie|program\sdo\sgry\sna\sgieldzie|Potega\stego\sprogramu\stkwi|program.{0,10}handluje.{0,10}zarabia.{0,10}gieldzie.{0,10}udzialu.{0,10}czlowieka|zarabiaj.{0,10}program.{0,10}nie.{0,10}jest.{0,10}zabroniony|Program.{0,10}zrobi.{0,10}wszystko.{0,10}sam|handluj.{0,10}na.{0,10}gieldzie.{0,10}programowi|100.{0,10}%.{0,10}pewnych.{0,10}transakcji|program.{0,10}100.{0,10}%.{0,10}zysk|handel.{0,10}bedzie.{0,10}zabroniony|program.{0,10}odmieni.{0,10}twoje.{0,10}zycie|system.{0,10}finansow.{0,10}przed.{0,10}upadkiem|grupa.{0,10}niemieckich.{0,10}matematykow.{0,10}inteligentny.{0,10}program|zostan\sobrzydliwie\sbogaty|technologia.{0,10}100%.{0,10}pewne.{0,10}decyzje|zarabianie.{0,10}w.{0,10}sieci|swoja.{0,10}szanse.{0,10}zarabianie|internet.{0,10}doprowadzil.{0,10}pieniedzy|zarabia.{0,10}(w|przez).{0,10}internet|karaluch.{0,10}dom.{0,10}brzeg.{0,10}morza|odmieni.{0,10}zycie|pieniadz|pieniedz|zarabia|zarobi/i#,
  q#__KAM_MOP3,[l=1]# => q#/filthy floor|cut cleaning time+absorbs \d+x its own weight|the mop that/i#,
  q#__KAM_MOTHER3,[l=1]# => q#/pro.?flowers|flowers.fresh|freshness.guarantee|shop.now|mom.?s.delight/i#,
  q#__KAM_MOVIE2,[l=0]# => q#/Movie Extra/i#,
  q#__KAM_NEUROLOGICAL3,[l=0]# => q#/at risk for alzheimers|alzheimers conspiracy|doctors hate him/i#,
  q#__KAM_NEWNOTICE1,[l=1]# => q#/- - -\s?(start |begin )?(of |new )?(notification|notice)( \d\d\/\d\d\/\d\d)?\s?- - -|notice of/i#,
  q#__KAM_NEWNOTICE2,[l=1]# => q#/- - -\s?(finish |end )?(of |new )?(notification|notice)( \d\d\/\d\d\/\d\d)?\s?- - -|end notice:/i#,
  q#__KAM_NEWS2,[l=0]# => q#/(?:Hello|hey|hi)!/i#,
  q#__KAM_NEW_CREDITCARD3,[l=1]# => q#/Select your new card|Increase Your Spending|Higher Limit|rewards|business credit|which.credit.card|find.out.now/i#,
  q#__KAM_NIGERIAN1,[l=1]# => q#/(?:payment officer|personal treasurer|experienced marketers|Chairman of the Finance Committee|contact my secretary|field of Financial Services|Head of Human Resources|Public Relation Officer|field of Business Services|payment agent|representing partner|vacancy in my company|representative\/book ?keeper|executor|search and selection of both experienced|retired chief economist|foreign partner|diplomatic courier|senior auditor|online book-?keeper)|in.your.country|united.state[^s]|states?.citizen|retired.ceo|nigeria|origin.finland|serious.illness|brain.(tumor|cancer)|former.minister|investment.partner|got.mugged|losing.my.(wife|only.son)/is#,
  q#__KAM_NIGERIAN2,[l=1]# => q#/(?:looking for dynamic representative|seek your partnership|new online business model|seek to transfer this money|completely legal activity|never ask you to pay or invest|in search of trustworthy representatives|establishing a new liaison network|rec[ei]{2}ving payment on our behalf|assist me in transferring those funds|make money at home|requiring rep to work on a part time|part time job\/full time|organization for the good work of the lord|job search directory|investor willing to invest in lebanon|invest in Real Estate|Your kind assistance|next of kin|gold.exportation|calgary.lotto)|oil.producing|import.firm|oil.and.gas|petroleum|asset.available|urgent.reply|(cash|credit.cards?|cell(.phone)?).(were|was).stolen/is#,
  q#__KAM_NIGERIAN2_1,[l=0]# => q#/congo/i#,
  q#__KAM_NIGERIAN2_2,[l=1]# => q#/barrister|director of central bank|bank director|former.minister|gold.dealer/i#,
  q#__KAM_NIGERIAN2_3,[l=1]# => q#/high court|central bank|payment center|customs?.officer/i#,
  q#__KAM_NIGERIAN2_4,[l=1]# => q#/e-?mail id is found among those that have been scammed|paid the fee for your cheque draft|contact the bank director/i#,
  q#__KAM_NIGERIAN2_5,[l=1]# => q#/fund code|cheque|bank draft|oil.and.gas/i#,
  q#__KAM_NIGERIAN2_6,[l=1]# => q#/full contact information requested|need your contacts informations|your bank account information|out.of.the.country/i#,
  q#__KAM_NIGERIAN2_7,[l=0]# => q#/bank|smuggle/i#,
  q#__KAM_NIGERIAN2_8,[l=1]# => q#/courier|diplomat agent|direct wire transfer|my.gold|the.gold/i#,
  q#__KAM_NIGERIAN2_9,[l=0]# => q#/scam|don't let them know that it is money|bank transfer charges/i#,
  q#__KAM_NIGERIAN3,[l=1]# => q#/(?:\d{1,2}\% (?:commission on each transaction|of the total will be set|will be mapped out|is made available to you|of the total sum for your partner|of the money for your effort|for\s+sales)|pay for performance|floating deficit|for your compensation|financial independence|their financial dreams|work from home part\s*-?\s*time|employing your services|get extra income|deduct your weekly salary \d\d%|transfer of the funds|make successful career at us|you will get \d{1,2}% on each|funds can be directed to your account as a grant|reasonable parentage|dormant domiciliary account|share would be \d+\%|pay you \d+%)|invest|have.a.sum|make.a.donation|immense.benefits|transact.a?.?business|company.sponsor|loan me \$/is#,
  q#__KAM_NIGERIAN4,[l=1]# => q#/(?:American oil merchant|independent contractor|removallink|claim the funds|international corporation|bank draft|becoming our contract staff|contractual employment|customers\s*in Europe,\s*America|new partner from UK|great investment site|money orders|cashiers check|access to the funds|piloting the business|moving the funds|next of kin|syrian.refugees|reply.for.detail)|security.reason|(his|her).account|new.investor|directly.beneficial|business.discussion|promise.to|need.to.spend/is#,
  q#__KAM_NIGERIAN5,[l=1]# => q#/Western Union Money Transfer|Money Gram|form of Money Orders|to apply for this job, please send the following|process our payments|not traceable|risk free transation|transfer to a designated bank account|inheritance return|my.inheritance|my.wealth|donation.to.you|out.of.country|charitable.trust/i#,
  q#__KAM_NOCONFIDENCE1,[l=1]# => q#/confidential.information/i#,
  q#__KAM_NOMORE1,[l=1]# => q#/no.more.of.this/i#,
  q#__KAM_NOMORE2,[l=1]# => q#/no.more.at.all/i#,
  q#__KAM_NOTIFY2,[l=1]# => q#/[2-9] friend request( |\b)|sell your personal|mandatory validation|verify your Account|unread messages/i#,
  q#__KAM_NUMEROLOGY3,[l=0]# => q#/Control your destiny/i#,
  q#__KAM_NURSE3,[l=1]# => q#/nurses (?:are NOW in high.?demand|are needed)|nursing Degree|indispensable.position|growing.career|nursing.assist|certified.nurs/i#,
  q#__KAM_NUWAVE3,[l=1]# => q#/nuwave|energy.saving|temperature.control|meal.prep|cooktop/i#,
  q#__KAM_OBFURL1,[l=1]# => q#/A\s+D\s+I\s+L\s+I\s+Z\+E\s+R\s+.\s+C\s+O\s+M/i#,
  q#__KAM_OCEANSBOUNTY3,[l=1]# => q#/years.of.aging|medical.doctor|age.revers|turn.back.the.clock|reactivate.your.heart/i#,
  q#__KAM_OILCHANGE3,[l=1]# => q#/fresh savings|find your favorite|discount.coupons|oil.change.is.due|local.provider|favorite.location|coupon/i#,
  q#__KAM_OPRAH1,[l=0]# => q#/airfare/i#,
  q#__KAM_OPRAH2,[l=0]# => q#/hotel/i#,
  q#__KAM_OPRAH3,[l=0]# => q#/oprah/i#,
  q#__KAM_ORDER1,[l=0]# => q#/Please find document attached/i#,
  q#__KAM_PACKAGE1,[l=1]# => q#/dysfunction|\dx longer/i#,
  q#__KAM_PACKAGE2,[l=1]# => q#/sexual.performance|longer.in.bed/i#,
  q#__KAM_PAPERLESS3,[l=1]# => q#/fax service|service plan|view.this.fax|\d.page.fax|voice.message/i#,
  q#__KAM_PASSWORD2,[l=1]# => q#/validate.your.email/i#,
  q#__KAM_PATRIOT3,[l=1]# => q#/the truth about|financial collapse|your guns|hidden agenda|unprecedented.crisis|disaster|fema (stock.?piling|storing)|Gor?vernment Not Telling|survival.plan|nation.gone.under|blind.with.patriotism|government shutdown|only chance|civil.unrest|high.crimes|behind.our.back|know.the.truth|PatriotNewsNet|second civil war|for.the.cia|market.crash|american.meltdown|concerned.american|military force|we.were.right|our.suspicions|vindicated|abuse.of.power|american.empire/i#,
  q#__KAM_PATRIOT4,[l=1]# => q#/projectprophet|financial.threat|nuke.deal/i#,
  q#__KAM_PAYMENT_LOWERED2,[l=1]# => q#/new monthly payment|just.recently.been..?lowered/i#,
  q#__KAM_PAYPAL2A,[l=0]# => q#/paypal/i#,
  q#__KAM_PAYPAL2B,[l=1]# => q#/protection services department|download(ing)?.the.attach/i#,
  q#__KAM_PAYPAL3D,[l=1]# => q#/security.process|more.information|has.limitation|verify.your.information/i#,
  q#__KAM_PEEL1,[l=1]# => q#/Titan Peeler/is#,
  q#__KAM_PEST3,[l=0]# => q#/revolutionary pes?t control system/i#,
  q#__KAM_PET3,[l=1]# => q#/pet health insurance|doggy.loot|coupon.notice|reduce.your.cost/i#,
  q#__KAM_PHISH2_2,[l=1]# => q#/Virginia Credit Union|Lloyds|HSBC|usaa|barclay|credit card account/is#,
  q#__KAM_PHISH2_4,[l=1]# => q#/unauthori[sz]ed use|security.enhancement|dropbox|hold.(on.)?your.fund/i#,
  q#__KAM_PHISH2_5,[l=1]# => q#/account suspension|temporary locked|temporarily.suspend|your.reference|accurately.detail/i#,
  q#__KAM_PHISH2_6,[l=1]# => q#/confirm your online banking details|payment.advice|online.fraud|billing.information/i#,
  q#__KAM_PHISH2_7,[l=1]# => q#/extra security check|security.tip/i#,
  q#__KAM_PHISH3_2,[l=1]# => q#/accessed by someone else./#,
  q#__KAM_PHISH4_2,[l=1]# => q#/dear.{0,50}customer|automated.message|spam.activities|attempted.gaining.access|your.account.expires|authorized.government|important.message|message.alert/i#,
  q#__KAM_PHISH4_3,[l=1]# => q#/(confirm|verify|update).your.(identity|account)|account.password|credit.(bureau|profile)|identity.theft|accredited.commission|security.concern|kindly.find.enclosed/i#,
  q#__KAM_PIC1,[l=1]# => q#/(tired|bored) (this )?(today|tonight|evening|morning|afternoon)|saw your email address|online right now|can name me|found you on this site|I am alone|my next boyfriend|blonde with blue|like the girls|crush on you/is#,
  q#__KAM_PIC2,[l=1]# => q#/(nice girl|2\d years old|25 y.o. girl|pretty russian|I russian girl|age is 25|long legs, cute|see my pictures|I'm 19|searching for a bad girl|meet with such attractive|cute lady)/is#,
  q#__KAM_PIC3,[l=1]# => q#/like to chat|feelings can be true|like to have friendship|friendly guy|gave me your photos|waiting on you|found your pictures|send me a note|more information about you|text me ASAP/is#,
  q#__KAM_PIC4,[l=1]# => q#/(like to share some of my pics|some (?:great )?pictures of me|sending some of my pictures|To see my pic|hope you like my pic|will reply with my pics|show you some pic|chat with me and see|that's my photo)|will send you my pictures|view my profile|describe yourself|chat with me|bad girl|view your snapshot|want to watch video|erotic pics/is#,
  q#__KAM_PIC5,[l=0]# => q#/picture|photo|my pics|appended my pic/i#,
  q#__KAM_PILLS2,[l=0]# => q#/be (thrifty|smart|clever), buy your (pills|drugs|medications)/i#,
  q#__KAM_PIZZA3,[l=1]# => q#/free.pizza.coupon/i#,
  q#__KAM_POLITICS2,[l=1]# => q#/Minuteman Civil Defense Corps|National Campaign Fund|Right vs Left|Restore America PAC|penntransportation.com|getliberty.org|Americans for Limited Government|radical|true.conservative|true.liberal|job.killing|wasteful.spending|senate.takeover|liberal.agenda|smear.campaign|america.s future|liberty|obama|governor|election.day|v-o-t-e|sign.the.petition|paid.for.by|dear.conservative|dear.liberal|winning.the.senate|election.cycle|return.power|failed.policy|(left|right).is.claiming|bigwigs|favorable.voters/i#,
  q#__KAM_POLY2,[l=0]# => q#/The End of Barack Obama/i#,
  q#__KAM_POWER1,[l=0]# => q#/hoveround/i#,
  q#__KAM_PRIV1,[l=0]# => q#/private message|horny|sweet ass/i#,
  q#__KAM_PRIV2,[l=0]# => q#/(personal|private) video/i#,
  q#__KAM_PRIV3,[l=0]# => q#/the attache?ment|attached file/i#,
  q#__KAM_PRODUCT2,[l=0]# => q#/phones for discerning individuals/i#,
  q#__KAM_PROPERTY3,[l=1]# => q#/convenient.location/i#,
  q#__KAM_PROPHET3,[l=0]# => q#/Dear Christian Friend/i#,
  q#__KAM_PROPHET4,[l=0]# => q#/Christian Media Ministry/i#,
  q#__KAM_PROPHET5,[l=0]# => q#/prophecy article|rapture/i#,
  q#__KAM_PSYCHIC3,[l=0]# => q#/psychic Chris|free psychic reading/i#,
  q#__KAM_QTJARS3,[l=1]# => q#/qtjars/#,
  q#__KAM_QTJARS4,[l=1]# => q#/private message/#,
  q#__KAM_QUOTA1,[l=0]# => q#/Mailbox Quota Has Exceeded|exceeded its storage limit/i#,
  q#__KAM_QUOTA2,[l=1]# => q#/Limited Access|termination of your email|restore.your.account|will.not.be.able/i#,
  q#__KAM_RAT2_1,[l=0]# => q#/job description/i#,
  q#__KAM_RAT2_2,[l=0]# => q#/dear shopper/i#,
  q#__KAM_REAL1,[l=1]# => q#/(^|\b)RE market/is#,
  q#__KAM_REAL2,[l=0]# => q#/(crashing|declining)/i#,
  q#__KAM_REAL2_1,[l=1]# => q#/(?:Property available|on the water|costa rica|mountain.top)/i#,
  q#__KAM_REAL2_2,[l=1]# => q#/(?:pre-development prices|finish building|torn down to build|exclusive place|ready.for.construction)/i#,
  q#__KAM_REAL2_3,[l=1]# => q#/(?:unbelievable deals|buyer with CA[s\$]h|pennies.on.the.dollar)/i#,
  q#__KAM_REAL2_4,[l=1]# => q#/(?:home sites|raw land|vacation home|wooded.property)/i#,
  q#__KAM_REAL2_5,[l=0]# => q#/(?:developers|estates|buyer flying in|retirement plans|liquidation)/i#,
  q#__KAM_REAL3,[l=1]# => q#/(vacation|second) (home|place)/is#,
  q#__KAM_RECALL3,[l=1]# => q#/protect.your.dog|recall?s.on.dog.?food|processing.standards|commercial.food/i#,
  q#__KAM_REFI2,[l=1]# => q#/(Free Evaluation (?:online|on your (?:current )?home loan)|No hidden costs|no strings attached|good credit or not|personalized consultation|in need of loan|consolidation loan|loan processing|apply by sending|loan of any amount|clean up any inacccuracies|lock in saving|save on monthly mortgage|absolutely no cost|underwater)|Reverse.?Mortgage|qualify for a VA loan|Refi now.? and Save|obama..?announces|rate.calculator|save.thousands|update: \d.\d\d..available|homeowner|over.your.head|rate.service|now.eligi?[bl]{2}e|a.second.mortgage|urgent.loan|loan.offer/is#,
  q#__KAM_REFI3,[l=1]# => q#/(restructure (?:proposal|program|opportunity|your loan)|switch from an adjustable rate to a fixed|new lending program|(low|reasonable) interest (loan|rate)|lowest monthly payment|\d% interest|unsecured personal|better credit terms|lower your mortgage|low-interest refinance|see your credit score|credit score.{1,15}updated|refi with HARP)|obama announce(s|d) (the )?harp program|obama'?s.refi|a.fortune.off|lower.home.rate|your.home|home.loan|gov.program|official.harp|currently.overpaying/is#,
  q#__KAM_REFI5,[l=1]# => q#/([\d,]{5,6}|\d{2}\s*%) savings|principal \d+% less|\d+\.\d+%.fixed|refi.calculator|lowered.requirements|home.?owner/is#,
  q#__KAM_REFI6,[l=1]# => q#/((?:reduce your monthly payment|save you) (between )?\d{2}\s*%|save yourself hundreds of dollars|great rate available|completely unsecured|instantly connect with\s+lenders|get you back on the right financial|get report today|protect against identity|know your credit score|crazy payments)|u.?s.? homeowners|drop.your.rate|in.your.pocket|our.records|apply.for.your/is#,
  q#__KAM_REFINEW2,[l=1]# => q#/(rate|payment).reduction|score-update/i#,
  q#__KAM_REHAB3,[l=0]# => q#/(?:drug|alcohol) (recovery|rehab|dependenc|addict|treatment)|help for alcoholism|life from alcohol|end your drinking|think about rehab/i#,
  q#__KAM_RELIGION3,[l=0]# => q#/Dear Christian|Christian Media/i#,
  q#__KAM_REMEMBERWHEN2,[l=1]# => q#/hello.brother|remember(ed)?.you|i.remember/i#,
  q#__KAM_REMEMBERWHEN3,[l=1]# => q#/medication|\d+%.discount|lots?.of.drug/i#,
  q#__KAM_REP1,[l=1]# => q#/Replace \[?[-!~\.]\]? with \./is#,
  q#__KAM_REP2,[l=1]# => q#/www\s+[-!~\.]/i#,
  q#__KAM_REP2_1,[l=1]# => q#/(Just|Please|all you need to do is to) (copy|type):? (www\s)?.{0,10}[\[\(]([-!~\.]|dot)[\]\)]/is#,
  q#__KAM_REP2_2,[l=0]# => q#/in your (IE|internet|explorer|browser)/i#,
  q#__KAM_REP3_1,[l=1]# => q#/\*omit empty spaces/is#,
  q#__KAM_REP3_2,[l=1]# => q#/.\s+(COM|org|net|info)$/i#,
  q#__KAM_REPAIR1_3,[l=1]# => q#/car.repair|Auto Protection|repair.bill|lowest.rates|need.repairs|cost.you.thousands|auto.warranty|costs.keep.rising|repair.cost|do.it.yourself|auto.body|body.repair|protection.quote/i#,
  q#__KAM_REPAIR2_3,[l=1]# => q#/never.pay|covered.home.repair|the.trouble|warning.signs|roofing.problem|roof.repair/i#,
  q#__KAM_REVIEW3,[l=1]# => q#/unverified|major.local.search|search.sites|company(.s)?.information/i#,
  q#__KAM_REWARD1,[l=1]# => q#/walgreens|ikea|sephora|sams.?club/i#,
  q#__KAM_RICH1,[l=1]# => q#/financial.success story/i#,
  q#__KAM_RICH2,[l=1]# => q#/see me on the channel \d news/i#,
  q#__KAM_RICH3,[l=0]# => q#/talking about my blog/i#,
  q#__KAM_RICH4,[l=1]# => q#/bec.me financially independent/i#,
  q#__KAM_RUIN1,[l=0]# => q#/do not deposit/i#,
  q#__KAM_RUIN3,[l=0]# => q#/banking institutions/i#,
  q#__KAM_RXPLAN3,[l=0]# => q#/gap coverage/i#,
  q#__KAM_SALE3,[l=1]# => q#/\d+%.off|just.shipped|touch.?fire|just.became.perfect|transform.your.ipad/i#,
  q#__KAM_SALEA_3,[l=1]# => q#/touchfire|just.became.perfect|never.be.the.same/i#,
  q#__KAM_SANTA2,[l=0]# => q#/Santa Letter|Letter from Santa|sent by Santa/i#,
  q#__KAM_SANTA3,[l=1]# => q#/the .?perfect.? gift|personalized letter/i#,
  q#__KAM_SCOOTER3,[l=0]# => q#/the scooter store/i#,
  q#__KAM_SEARCH2,[l=1]# => q#/search engine|SEO|bring.traffic|business.development/i#,
  q#__KAM_SEARCH3,[l=1]# => q#/(first on|all of) the major search|not ranked number one|Website promotion|popular keywords|mobile.website|complete.solution|back.link|india.based|surfing|not.ranking.on/i#,
  q#__KAM_SEARCH4,[l=1]# => q#/guaranteed type of exposure|free website search engine optimi|increase your revenue|improve your website traffice|website rank higher|marketing service|popular.keyword|media.presence|media.portal|brand.awareness|analytics.certified|optimized.content|white.label|website.optimization|digital.marketing|in.your.industry/i#,
  q#__KAM_SECURITY3,[l=1]# => q#/information.security|cyber.?criminal/i#,
  q#__KAM_SEENTHIS1,[l=1]# => q#/have.you.seen|seen.this/i#,
  q#__KAM_SELL2,[l=0]# => q#/Easy Money/i#,
  q#__KAM_SELL3,[l=0]# => q#/Selling Credit Cards/i#,
  q#__KAM_SELLPHONE1,[l=0]# => q#/Turn iphones into cash/i#,
  q#__KAM_SELLPHONE2,[l=0]# => q#/used or broken|pre-paid envelope/i#,
  q#__KAM_SEO2,[l=0]# => q#/(?:top|first page) (?:in|of) (?:Google|MSN|Yahoo|Bing)|rank number one|top page rank|guarantee you 1st|link.building/i#,
  q#__KAM_SEO3,[l=1]# => q#/never find your web site|major search engines|link.building|WEBSITE AUDIT REPORT|specific.keyword|targeted.email|visited.your.website/i#,
  q#__KAM_SEO4,[l=1]# => q#/No upfront fees|SEO Specialists|online marketing services|S.?E.?O.? Company in INDIA|google.panda|google.penguin|not.ranking/i#,
  q#__KAM_SEO5,[l=1]# => q#/more traffic guaranteed|results in thirty day|top 5 organic|high revenue|free.analysis|guaranteed.top/i#,
  q#__KAM_SEO6,[l=1]# => q#/will not get your website banned|Google.?s SEO policies|six month ongoing campaign|web.promotion/i#,
  q#__KAM_SETTING2,[l=0]# => q#/security upgrade|Maintenance Process on our email system /i#,
  q#__KAM_SETTING3,[l=1]# => q#/settings?.zip/i#,
  q#__KAM_SETTLEMENT3,[l=1]# => q#/lawsuit.information/i#,
  q#__KAM_SEX04_1,[l=1]# => q#/(curative|medicinal|salutary|wholesome|beneficial|satisfaction) effect|(first-rated|splendid) drugs|(yellow|blue|famos) (tablet|pill)|good medical supplies|(commendable|valuable) medicines|canadian pharmacy|GNC|nugenix/is#,
  q#__KAM_SEX04_2,[l=1]# => q#/fun in bed|(bed|night) adventures|aid your bed|(lift|heave|ascent|hoist|raise|boost|aid) your (belove|love|darling|sex|sweet)|sexuality with assistance|ascent your sweet|bed experience|love sexuality/is#,
  q#__KAM_SEX04_4,[l=1]# => q#/longer your tool|sexual experience|empower your (belove|sex)|sweet sex|(not bad|great|nice|special|awesome|free) bonus|sex all night|lovers package|male.vitality/is#,
  q#__KAM_SEX05_2,[l=0]# => q#/buy rubber friends|big bait in your pants|she sees your size|women will be funk|biggest tool|immense monster|women will be daydreaming|have so much meat|prolonging your size|last a lot longer/i#,
  q#__KAM_SEX06_1,[l=0]# => q#/more fire and passion/i#,
  q#__KAM_SEX1,[l=1]# => q#/(?:double[ -]?headed|pornstar|huge weenie|male power|\d\dper\. of men|male enhancement product|enlarge patch|boost up your virility|clinically tested|improve manhood|Bigger Pen..is|Big Penis|incredible gains to your manhood|muscular manhood|nights unsatisfied|climaxes|sensual enhancer|love instrument|bigger member|excitement with girls|fucker|animal sex)|adds \d inches to your manhood|pussy licked|hard.erection/i#,
  q#__KAM_SEX2,[l=1]# => q#/(?:(\b|^)cunt(\b|$)|busty|interracial|hardcore|peni(s|le) enlarge|generic quality|enlarge your manhood|stone-hard manhood|XXL Dick|intense pleasure|spend a night with you|efficient medicine|turn on your wife|with your boner|dick dangl)|\d.(extra.)?inches.of.girth|best.sex/i#,
  q#__KAM_SEX4,[l=0]# => q#/(?:bring your girlfriend back|satisfied with their size|penis so huge and heavy|more semen|volume of your loads|wondercum|ejaculate|bargain offers on medic|improve xxx|improve your lovemaking|youngest teen|teen pics|monster in his pants|(female|multiple) orgasms|extreme penetration)/i#,
  q#__KAM_SEX_EXPLICIT4,[l=1]# => q#/(?:fucked hardcore|dildoes her tight ass|kinky watersports|schoolgirls? slut|teens? porn|first anal(\b|$)|pussy lips|kinky lesbian|sucks? cock|rub puss|spreads? cunt|fetish babe|kinky pee|muffdived \& fuck|deepthroat on knees|hello.naughty.boy|certain.type.of.guy|girlfriend.trick|sexual.stamina|sex...toy|porn.link|cunt.fuck|c-o-c-k|non.stop.sex|porn.industry|stronger.erection|make.her.moan|extreme.pro.abortion|erection.problem|your.erection|get.an.erection|hardest.erection|get.erect|xxx gay|asian porn|blowjob porn|anal xxx|huge tits tube|xxx tube|porn tube|fuckbook|portal for xxx|3d porn|DrPEnterprise|girlfriends.porn|\bsex.galler|pussy.eaten|shemale|anal.adventure|black.girls.video|gay.porn|pussy.wet|make.her.horny|crave sex|women.fuck|women.horny|wanting.to.bang|getting.laid.is.simple|woman.on.her.knees|b r e a s t|generic.ed.product|best.sex|f[^a-z]cking.you|f[^a-z]ckbuddy|F[hash]ckFriends|Milf Selfies|need.a.horny.man|cute.sex.lover|horny.as.f.ck|fun.in.the.bedroom|my.tits.are|be.horny|horny.girl|horny.i.am|horny.latina|huge.dildo|made.me.climax|sex in my office|a.good.f\@ck|married.horny.woman|sucked.your.d\@ck|horny.milf|suck.you.off|horny.stories|all.my.h[o0]les|cum.heavily|sucking.your.c[o0]ck|to.get.f[^a-z]cked)|h00kup|s\*xy|\bh0rny|ch0ked|pu\$\$y|f\*cked|F[hash]ck|F\*ck_|find milfs/i#,
  q#__KAM_SEX_EXPLICIT6,[l=0]# => q#/virus on a porn web/i#,
  q#__KAM_SHAM3,[l=0]# => q#/ShamWow/i#,
  q#__KAM_SHAM4,[l=0]# => q#/20(X| times) its weight/i#,
  q#__KAM_SHARP1,[l=0]# => q#/sharp for life/i#,
  q#__KAM_SHARP2,[l=0]# => q#/yoshiblade/i#,
  q#__KAM_SHARP3,[l=0]# => q#/zirconium oxide/i#,
  q#__KAM_SHARP4,[l=0]# => q#/ceramic knife/i#,
  q#__KAM_SHOCK1,[l=1]# => q#/shocking.beverage/i#,
  q#__KAM_SHOCK3,[l=0]# => q#/drinking this beverage/i#,
  q#__KAM_SHOP1,[l=1]# => q#/chosen to participate as a Mystery Shopper/is#,
  q#__KAM_SHOP2,[l=1]# => q#/Do you like to shop/is#,
  q#__KAM_SHOP3,[l=1]# => q#/make money while you shop/is#,
  q#__KAM_SILD2,[l=0]# => q#/(XtraSize\+|Sildenafil Citrate)/i#,
  q#__KAM_SINGING3,[l=1]# => q#/terrible.singer|more.talent|love.songs/i#,
  q#__KAM_SKIN4,[l=1]# => q#/feet feel smooth and healthy|calluses and dead skin|silky smooth skin|tighter skin|\d.years.younger|anti[- ]aging|look younger|free trial|lose 25 years|angered plastic surge|quick and easy trick|anti-?aging|blood pressure low|heart rate monitor|selfies|just.one.month|just.four.weeks|medical.research|rebuild.your.skin|decades.younger|erase.time|gossip|smooth.lines/i#,
  q#__KAM_SKYPE4,[l=1]# => q#/Promo Code: \d/i#,
  q#__KAM_SLICEOMATIC3,[l=0]# => q#/Slice-o-matic/i#,
  q#__KAM_SMOKE1,[l=1]# => q#/smoke.anywhere|electronic cig|smoking alternative|prado|e.?-?cig|wanting to quit/i#,
  q#__KAM_SMOKE4,[l=1]# => q#/No carbon monoxide|Smokeless Direct|No Tobacco|no tar|no cancer|quit smoking|electronic cig|sinless.vapor/i#,
  q#__KAM_SMOKE5,[l=0]# => q#/you have qualified/i#,
  q#__KAM_SNORE3,[l=1]# => q#/stop snoring|zquiet|Jaw Supporter|get.rest|end.snoring|more.rest|to.be.tired/i#,
  q#__KAM_SOCKET3,[l=0]# => q#/side socket/i#,
  q#__KAM_SOFTWARE3,[l=0]# => q#/Fix file errors/i#,
  q#__KAM_SOFTWARE4,[l=0]# => q#/download for no cost|FREE Software|Free Analysis|Free Report/i#,
  q#__KAM_SOLAR3,[l=1]# => q#/power bill in half|go solar|approved for solar|solar system saves|reduce your electric|energy.cost|energy.bill|government.incentive|can.profit|utility.bill|switch(ing)?.to.solar|solar.incentive|solar.now|US Solar Dept|your.electric.bill|your.home.qualifies/i#,
  q#__KAM_SPAMKING1,[l=1]# => q#/This advertisement is presented by/is#,
  q#__KAM_SPAMKING2,[l=1]# => q#/If you have any questions or concerns regarding this communication, please send correspondence/is#,
  q#__KAM_SPAMKING3,[l=1]# => q#/To .{0,30}(?:unsubscribe|stop|remove) .{0,35}(?:email|messages) from third party advertisers/is#,
  q#__KAM_SPAMKING4,[l=1]# => q#/notify .{0,30} that you no longer wish to receive (?:promotional )?messages/is#,
  q#__KAM_SPAMKING5,[l=1]# => q#/This (communication|message) was delivered to you by/is#,
  q#__KAM_SPAMKING6,[l=1]# => q#/(?:please send|Forward postal) correspondence to/is#,
  q#__KAM_SPY3,[l=1]# => q#/spy.?camera.?system|hidden.spy.camera|valuables.safe|protect.your.children/i#,
  q#__KAM_STAR1,[l=0]# => q#/REMOVE ("\*"|space) (in the above|to make the) link/i#,
  q#__KAM_STATLER3,[l=0]# => q#/Mike Statler/i#,
  q#__KAM_STOCK2_1,[l=1]# => q#/(good trader|trading experience|bad trading day|hard trading day|FREE Stock Market Outlook|Market Watch)|more.than.\d+%|most.valuable|morning.report|real.?estate.authority|commercial.real.estate/i#,
  q#__KAM_STOCK2_2,[l=1]# => q#/(easy cash|losses and victories|backstage trading|market facts|succeed in trading|destined to skyrocket|make traders rich|times your principal)|good.investment|overvalued.companies|company.is.soaring|economic.opportunity|amazing.company|take.notice|rental.yield|high.return/i#,
  q#__KAM_STOCK2_3,[l=0]# => q#/stock/i#,
  q#__KAM_STOCK2_4,[l=0]# => q#/trader|investor|analyst|royalties/i#,
  q#__KAM_STOCK3,[l=1]# => q#/([sS].?ymbol|Sym|SYM|SYMB|Symb|SYMBOL|SYmN|SYMN|Symn|Ticker|TICKER|Lookup|PINKSHEETS)\s*[-_:]\s*[A-Z0-9][-\._ ]?[A-Z0-9][-\._ ]?[A-Z0-9][-\._ ]?[A-Z0-9]/#,
  q#__KAM_STOCKBULL,[l=1]# => q#/bull (run|market)|very.rich|high.return/is#,
  q#__KAM_STOCKJUMP,[l=1]# => q#/(up|jumps) \d\d(\.\d)?\%/i#,
  q#__KAM_STOCKOBFU1,[l=1]# => q#/make up the \d letter symbol/i#,
  q#__KAM_STOCKOBFU2,[l=0]# => q#/first letter/i#,
  q#__KAM_STOCKOTC,[l=1]# => q#/(OTC|OTC ?BB|OTC Pink Sheets|NASDAQ|NYSE|StockWatch):/is#,
  q#__KAM_STOCKSCTR,[l=1]# => q#/(energy sector|mineral rights|mineral wealth|natural resources|gold deposits)/is#,
  q#__KAM_STOCKSHR,[l=1]# => q#/\b(Shares|Investments|invest|Stock|acquisitions?|broker|joint[ -]?venture|underperforming|(uncap|ventilated|public(ity)?) on friday|dividend opportunities|set your buy|financial safe haven|before the bell)\b/i#,
  q#__KAM_STOCKTIP121,[l=1]# => q#/(VISION AIRSHIPS|(\b|^)VPSN(\b|$))/is#,
  q#__KAM_STOCKTIP122,[l=1]# => q#/(Shandong Zhouyuan Seed and Nursery|(\b|^)SZSN(\b|$))/is#,
  q#__KAM_STOCKTIP124,[l=1]# => q#/(VGPM|Vega Promotional Sys)/is#,
  q#__KAM_STOCKTIP127,[l=1]# => q#/(Physical Property Holdings|(\b|^)PPYH(\b|$))/is#,
  q#__KAM_STOCKTIP128,[l=1]# => q#/(MONUMENTAL MARKETING|(\b|^)MNUM(\b|$))/is#,
  q#__KAM_STOCKTIP129,[l=1]# => q#/(EnerBrite Technologies Group|(\b|^)eTgU(\b|$))/is#,
  q#__KAM_STOCKTIP130,[l=1]# => q#/(Pricester|(\b|^)PRCC(\b|$))/is#,
  q#__KAM_STOCKTIP131,[l=1]# => q#/(Greenstone Holdings|(\b|^)GSHN(\b|$))/is#,
  q#__KAM_STOCKTIP132,[l=1]# => q#/((\b|^)AGMS(\b|$)|Angstrom[- ]Microsystems)/is#,
  q#__KAM_STOCKTIP133,[l=1]# => q#/(Pluris Energy|(\b|^)PEYG(\b|$))/is#,
  q#__KAM_STOCKTIP134,[l=1]# => q#/(United Consortium|(\b|^)UCSO(\b|$))/is#,
  q#__KAM_STOCKTIP135,[l=1]# => q#/(Dominion Minerals|(\b|^)DMNM(\b|$))/is#,
  q#__KAM_STOCKTIP136,[l=1]# => q#/(PrimeGen Energy|(\b|$)PGNE(\b|^))/is#,
  q#__KAM_STOCKTIP137,[l=1]# => q#/Dynamic Response Group|(\b|^)DRGZ(\b|$)/is#,
  q#__KAM_STOCKTIP138,[l=1]# => q#/Cobra Oil (and|&) Gas|(\b|^)CGCA(\b|$)/is#,
  q#__KAM_STOCKTIP139,[l=1]# => q#/Solanex Management|(\b|^)SLNX(\b|$)/is#,
  q#__KAM_STOCKTIP140,[l=1]# => q#/BIO-SOLUTIONS|(\b|^)BISU(\b|$)/is#,
  q#__KAM_STOCKTIP142,[l=1]# => q#/Hawk Systems Inc|(\b|^)HWSYD(\b|$)/is#,
  q#__KAM_STOCKTIP143,[l=1]# => q#/AmeriLithium/is#,
  q#__KAM_STOCKTIP144,[l=1]# => q#/Fleet Management Solutions|(\b|^)FLMG(\b|$)/is#,
  q#__KAM_STOCKTIP146,[l=1]# => q#/Plandai|(\b|^)PLPL(\b|$)/is#,
  q#__KAM_STOCKTIP148,[l=1]# => q#/(\b|^)STBV(\b|$)/i#,
  q#__KAM_STOCKTIP149,[l=1]# => q#/LifeApps|(\b|^)LFAP(\b|$)/i#,
  q#__KAM_STOCKTIP150,[l=0]# => q#/MONARCHY RESOURCES/i#,
  q#__KAM_STOCKTIP151,[l=0]# => q#/Alanco Tech/i#,
  q#__KAM_STOCKTIP152,[l=0]# => q#/Siga Resources/i#,
  q#__KAM_STOCKTIP153,[l=1]# => q#/INSCOR|(\b|^)IOGA(\b|$)/is#,
  q#__KAM_STOCKTIP154,[l=1]# => q#/mLight Tech|(\b|^)MLGT(\b|$)/is#,
  q#__KAM_STOCKTIP155,[l=1]# => q#/Alanco Technologies/is#,
  q#__KAM_STOCKTIP156,[l=1]# => q#/Progress Watch|(\b|^)PROW(\b|$)/is#,
  q#__KAM_STOCKTIP157,[l=1]# => q#/(\b|^)PRFC(\b|$)/is#,
  q#__KAM_STOCKTIP163,[l=1]# => q#/(\b|^)(brixmor)(\b|$)/is#,
  q#__KAM_STOCKTIP166,[l=1]# => q#/(\b|^)(INCT|Incapta)(\b|$)/is#,
  q#__KAM_STOCKTIP167,[l=1]# => q#/(\b|^)(QSMS|Quest Management|Quest Science Management Gate)(\b|$)/is#,
  q#__KAM_STUDENT3,[l=1]# => q#/penalt(y|ies)|garnish|your.debt|president.loan|reduce.(your.)?(student.)?loan|forgiveness.plan|qualify.for|federal.program|low.monthly/i#,
  q#__KAM_STUDENTLOAN1,[l=0]# => q#/(National|Federal) Student Loan Status/i#,
  q#__KAM_STUDENTLOAN2,[l=0]# => q#/consolidate your loan/i#,
  q#__KAM_STUDENTLOAN3,[l=0]# => q#/doesn't injured/i#,
  q#__KAM_STUDENTLOAN4,[l=0]# => q#/866-351-4693/i#,
  q#__KAM_STUDENTLOAN5,[l=0]# => q#/(financial troubles|debt) is (understood|forgiven)/i#,
  q#__KAM_SUNGLASSES2,[l=1]# => q#/great ray|hot.deal/i#,
  q#__KAM_SUNGLASSES3,[l=1]# => q#/style rocks|today.only/i#,
  q#__KAM_SUPERHUMAN3,[l=1]# => q#/reclaim your glory|stay hot and sexy|unfair.advantage|better sex|weird trick|testosterone/i#,
  q#__KAM_SURVEY3,[l=0]# => q#/Do You Use Instagram|Complete the survey|win a great prize/i#,
  q#__KAM_SWIPE3,[l=1]# => q#/pennies on the dollar|join, bid|penny (auctions|stock)|\d% .{0,10}retail|ipads on auction|bid now|factory sealed ipads|cheap ipads|for pennies|ebay killer|Inventory Clearance on iPads|crazy auctions|XPS for \d\dUSD|iphone.{1,10}clearance|the.hottest/i#,
  q#__KAM_SWIPE4,[l=1]# => q#/SwipeBids|Swipe Auction|CIRCLE MEDIA BIDS|Wavee|BIGGER BIDDER|Bidooka|Sellmoo|overstocked auctions|for pennies|\d{1,2} cent/i#,
  q#__KAM_TAX3,[l=1]# => q#/File your taxes for free|need more time|back.taxes|tax relief|irs offer|avoid penalty|stop.aggressive.collections|relief.(program|package)|tax.settlement|settlement.package|paying.bills|paying.tax|back.tax|wage..?garnish|tax.help|remove.lien|bankrupt|urgent.tax.notice|could.change.everything|instantly.save.you/i#,
  q#__KAM_TAX4,[l=1]# => q#/MSNBC|fox news|CNN|please.confirm|you.qualify|obtain.now|must.see.tax/i#,
  q#__KAM_TELEWORK1,[l=1]# => q#/(generate|make) .{0,10}1.5K? (to|-) 3.5K (a day|daily|per day|per month)|makes? \$[\d,]+\/month|upgrade your salary/is#,
  q#__KAM_TELEWORK2,[l=1]# => q#/have a (?:tele)?phone|money making challenge|has full internet/is#,
  q#__KAM_TELEWORK3,[l=1]# => q#/return(?:ing)? (phone )?calls|working a few hours each day|positive work environment/is#,
  q#__KAM_TELEWORK4,[l=1]# => q#/fully qualified|no experience needed|all the training|managing expectations|accountability|stronger results/is#,
  q#__KAM_TELEWORK5,[l=1]# => q#/work (?:online )?from home|process(?:ing)? rebates (?:at|from) home|set your own hours|100% no risk|Western Union fees|new job or career/is#,
  q#__KAM_TELEWORK6,[l=1]# => q#/earning up to \d+USD|earn thousands of dollars|\d% commission|get rich quick|manager training|real.payoff/is#,
  q#__KAM_TESTOSTERONE3,[l=1]# => q#/Boost your testosterone|get your body back|low.testosterone/i#,
  q#__KAM_TESTOSTERONE4,[l=1]# => q#/Testoril|sexual confidence|androgel|axiron+androderm/i#,
  q#__KAM_THIRD,[l=1]# => q#/advertisement.{0,12}sent by a third-?party|sent.by.tb.systems|is.an.advert[il]se?ment/i#,
  q#__KAM_TIME2,[l=1]# => q#/(replica(\b|$)|diamond|designer[-_ ](piece|collections|watch)|time[-_ ]piece|wrist|time-keeper|\/\/atch)/is#,
  q#__KAM_TIME4,[l=1]# => q#/(\b|^)(time|watch)(\b|$)/i#,
  q#__KAM_TIME5,[l=1]# => q#/(funny|low) price|treat.yourself/i#,
  q#__KAM_TIME6,[l=0]# => q#/(Cx?ARTIER|Bx?REITLING|Px?ATEK|Rx?OLEX|Bx?VLGARI|Tx?IFFANY)/i#,
  q#__KAM_TIMESHARE1,[l=1]# => q#/Get[- ]Cash for Your Timeshare|not using your timeshare|(unwanted|ugly) timeshare|cash out quickly/is#,
  q#__KAM_TIMESHARE2,[l=1]# => q#/goldmine|sell or rent it|we pay cash|sell\/rent your time|own a timeshare or condo|get.cash|find.your.value/is#,
  q#__KAM_TINNI1,[l=0]# => q#/TinniFix/i#,
  q#__KAM_TINNI2,[l=0]# => q#/Stop the ringing in your ears/i#,
  q#__KAM_TINNITUS3,[l=1]# => q#/scientifically.proven|end.tinnitus/i#,
  q#__KAM_TIP3,[l=0]# => q#/undereye bags/i#,
  q#__KAM_TIP4,[l=0]# => q#/Find Out This Quick New Trick/i#,
  q#__KAM_TIRES3,[l=0]# => q#/savings on tire|new tires/i#,
  q#__KAM_TOLL3,[l=1]# => q#/have.not.paid|your.debt|invoice/i#,
  q#__KAM_TOURS3,[l=1]# => q#/your.adventure.tour|your.event/i#,
  q#__KAM_TRIAL,[l=1]# => q#/RISK-FREE Trial|Free \d+ day trial|try it free|free.dvd.info|free.info.kit|limited..?trial|claim.package/i#,
  q#__KAM_TRUMPCOIN1,[l=0]# => q#/Donald Trump/i#,
  q#__KAM_TRUMPCOIN3,[l=0]# => q#/special colored coin/i#,
  q#__KAM_TUB3,[l=1]# => q#/Walk.?in (hot.?|bath.?)?tub|bath and massage|easy transfer from a wheelchair/i#,
  q#__KAM_TUPPERWARE3,[l=0]# => q#/tupperware lid|food storage|storage container/i#,
  q#__KAM_TV1,[l=1]# => q#/watch unlimited television|DTV4PC|Online TV Code|Free DVD-CD Burner|100% legal|Rabbit TV|reliable.cable.service|existing.smart.tv/i#,
  q#__KAM_TV2,[l=1]# => q#/without a monthly fee|pay a cable or satellite bill|no monthly fee|watch uncensored|movies online|no censorship|favorite.channels|online.television|\d{3}.channels|high.speed|sysview/i#,
  q#__KAM_TVDOCTOR3,[l=1]# => q#/clinical|miracle|dermatologist|anti.?.?aging.tip|\d+.years.younger|wrinkle.(reduction|prevention)|\bOMG!\b|loose.\d+.lb|tv.doctor/i#,
  q#__KAM_UNIV1,[l=1]# => q#/(University Administration|University Enrollment|Education Assessment|Faculty Assessment|University Degree|Administration Office|Education office|Schools office|Enrollment Office|Online University)/is#,
  q#__KAM_UNIV11,[l=1]# => q#/(degree|transcript) in any field|Field of yourr? ch[o][i]ce/is#,
  q#__KAM_UNIV12,[l=1]# => q#/(obtain your diploma|diploma that you want|Criminal Justice or Homeland Security degree)/is#,
  q#__KAM_UNIV13,[l=1]# => q#/(degree|field|diploma) of your (choice|expertise)/is#,
  q#__KAM_UNIV14,[l=1]# => q#/(earn a|full) transcript/is#,
  q#__KAM_UNIV15,[l=1]# => q#/(No Study Required|Without Exams|No (examinations|[e]xams)|without attending a single class|no classes|no textbooks|no (?:required )?tests|degree .{0,30}you deserve)/is#,
  q#__KAM_UNIV16,[l=1]# => q#/\d weeks.{0,30}graduated/is#,
  q#__KAM_UNIV18,[l=1]# => q#/100% discrete/is#,
  q#__KAM_UNIV1B,[l=1]# => q#/\d (months|weeks)/i#,
  q#__KAM_UNIV2,[l=1]# => q#/\d (week|month).{0,30}degree/is#,
  q#__KAM_UNIV3,[l=1]# => q#/(past work|based on your|earned from|life|life and work|present work) experience/is#,
  q#__KAM_UNIV3B,[l=1]# => q#/(dead end job|improve your future, and your income|high paying jobs|bec[o]me a do[c]tor|get your diploma today)/is#,
  q#__KAM_UNIV4,[l=1]# => q#/not official degree|non[ -]?accredited/is#,
  q#__KAM_UNIV4B,[l=1]# => q#/1.?0.?0.?% (legit|verifiable|online|no pre|non[- ]?accredited)/is#,
  q#__KAM_UNIV5,[l=1]# => q#/novelty (degree|use)/is#,
  q#__KAM_UNIV5B,[l=1]# => q#/F A S T[ ]{0,4}T R A C K/is#,
  q#__KAM_UNIV6,[l=1]# => q#/verifiable University Degree/is#,
  q#__KAM_UNIV6B,[l=1]# => q#/DIP\sLOMA/#,
  q#__KAM_UNIV7,[l=1]# => q#/(life|work) experience (diploma|degree|transcript)/is#,
  q#__KAM_UNIV8,[l=1]# => q#/Career Path/is#,
  q#__KAM_UNIV9,[l=1]# => q#/non[- ]?ac(creditee?d)?.{1,10}universit/is#,
  q#__KAM_UNSUB1,[l=0]# => q#/cancel 0ffers/i#,
  q#__KAM_UPS3,[l=0]# => q#/invoice copy attached/i#,
  q#__KAM_URONLINE1,[l=1]# => q#/(chat|chat with me|hook ?up) on Y ?A ?H ?O ?O (tonight|or MSN)|add me with yahoo or msn|view now|press this web link|send me your? photo|can u turn me on|kissing you|begin.a.chat/i#,
  q#__KAM_URONLINE2,[l=1]# => q#/wanna talk|ur info|found your mail|found ur profile|mutual friend|katya from russia|you came to russia|my gentle sun|see this page I made|match making heaven|meet that special|comee see it over here|hexten.net|looking for a man|waiting for ur mail|found ur account|waiting for your message|casual.hookup/i#,
  q#__KAM_URONLINE3,[l=1]# => q#/get (naked|naughty)|horny|naughty toys|I will do anything|TOTALLY msg me on MSN|tell me your mobile|I remember you|let's talk|ran across someone like u|sexywebdating|chatting with someone|saw you by BJs|private e-?mail|dating portal|looking.for.fun/i#,
  q#__KAM_URUNIT1,[l=1]# => q#/\bur (unit|liveliness|energy level|endurance level)/is#,
  q#__KAM_URUNIT2,[l=1]# => q#/\bur (gf|girl|wife|size|thing|partner|significant other)/is#,
  q#__KAM_URUNIT3,[l=1]# => q#/(unsatisfied|not satisfied|nagging|complaining|complaints|complained|unlimited prowess|increase your volume)/is#,
  q#__KAM_URUNIT3A,[l=1]# => q#/\b(exasperated|fatigued|drained|tired) all the time/is#,
  q#__KAM_URUNIT4,[l=1]# => q#/(bedroom|the bed|nighttime activit|male power|show your girl)/is#,
  q#__KAM_URUNIT5,[l=1]# => q#/(size of (there|their|your) .{0,11}(unit|thing)|using them for a couple months|enhancing formula)/is#,
  q#__KAM_URUNIT6,[l=1]# => q#/(majority of women|shrinking .{0,12} baby fat|winning guy|huge explosion)/is#,
  q#__KAM_URZEST2,[l=0]# => q#/or still (?:jaded|worn|drained|exasperated) all the time/i#,
  q#__KAM_URZEST3,[l=0]# => q#/(?:(?:wanting|looking|seeking) to get in the gym|(?:dreaming|seeking|hoping) to get (?:into shape|fit))/i#,
  q#__KAM_URZEST4,[l=0]# => q#/(wks it has been|been mos) since we('| ha)ve chatted/i#,
  q#__KAM_URZEST5,[l=0]# => q#/(back into shape|made me healthier after my disease)/i#,
  q#__KAM_USB1,[l=0]# => q#/(debi|deborah brown|Melissa Sylvan)/i#,
  q#__KAM_USB2,[l=0]# => q#/person (that|who) handles the promotions/i#,
  q#__KAM_USB3,[l=1]# => q#/usbsmg.com/i#,
  q#__KAM_VACATION3,[l=1]# => q#/Resorts FOR FREE|(carr?ibb?ean|alaskan?).cruise|top deals/i#,
  q#__KAM_VIAGRA4A,[l=1]# => q#/V (. )?A (. )?L (. )?[I\/t] (. )?U (. )?M/i#,
  q#__KAM_VIAGRA4B,[l=1]# => q#/V (. )?[I\/t] (. )?A (. )?G (. )?R (. )?A/i#,
  q#__KAM_VIAGRA7A,[l=1]# => q#/V[ij]+AGRA/i#,
  q#__KAM_VIAGRA7C,[l=1]# => q#/(^|\b)AMB[ij]+EN($|\b)/i#,
  q#__KAM_VIAGRA7D,[l=1]# => q#/VAL[ij]+UM/i#,
  q#__KAM_VIAGRA8A,[l=1]# => q#/VI...?AGRA/i#,
  q#__KAM_VIAGRA8B,[l=1]# => q#/AM...?BIEN/i#,
  q#__KAM_VIAGRA8C,[l=1]# => q#/VA...?LIUM/i#,
  q#__KAM_VIAGRA8D,[l=1]# => q#/CI...?ALIS/i#,
  q#__KAM_VIAGRA9A,[l=1]# => q#/V[IL1]A..GRA/i#,
  q#__KAM_VIAGRA9B,[l=1]# => q#/AMB..IEN/i#,
  q#__KAM_VIAGRA9C,[l=1]# => q#/VAL..IUM/i#,
  q#__KAM_VIAGRA9D,[l=1]# => q#/C[IL1]A..LIS/i#,
  q#__KAM_VIAGRA_FPS,[l=0]# => q#/via gra|i augur/i#,
  q#__KAM_VISION3,[l=1]# => q#/100%.natural|vision.restored|currently.wear.(glasses|contacts)|perfect.vision|risky.surgery|corrective.surgery|dangers.of.surgery|laser.eye|eye.care|making.your.eyes.worse|your.glasses|worsen.your.vision|special.prices|vision.in.\d+.day|vision.in.\d+.week/i#,
  q#__KAM_VOICEMAIL3,[l=1]# => q#/new voice.?mail message|voice.redirected/i#,
  q#__KAM_WALKINTUB3,[l=1]# => q#/walk.?in.?tub/i#,
  q#__KAM_WARRANTY2,[l=0]# => q#/Protect your home|choice home warranty|unexpected repair/i#,
  q#__KAM_WARRANTY3,[l=0]# => q#/home warrant|complimentary insurance quote/i#,
  q#__KAM_WATER1,[l=0]# => q#/Never Drink Water/i#,
  q#__KAM_WATER3,[l=0]# => q#/filtered tap water/i#,
  q#__KAM_WEB2,[l=1]# => q#/INDIA based IT|indian.based.website|certified.it.company/i#,
  q#__KAM_WEB3,[l=1]# => q#/Online Marketing Consultant|possible.redesign|seo.service|mobiles?.app|business.develop|commerce.solution/i#,
  q#__KAM_WEBINAR4,[l=1]# => q#/executive.education|contactid|register now|\d+.minute webinar|management.position|supervising.skills|discover.tips|register.early|take.control|marketing.capabilit|drive.more.sales|leveraging.cloud|solution.provider|have.a.handle|plan.to.divest|being.informed|upcoming.webinar|spearfishing.email|increase.revenue|industry.podcast|\d+.in.depth.tips|early.bird.offer|pmp.certified|lunch.briefing/i#,
  q#__KAM_WEB_OBFUSCATION1,[l=1]# => q#/check over this commercial|see the commercial.advertisement/i#,
  q#__KAM_WEED1,[l=1]# => q#/legal.weed|jim kramer|kevin james/i#,
  q#__KAM_WEED3,[l=0]# => q#/doubled? (there|their) money|Triple this afternoon/i#,
  q#__KAM_WEED4,[l=1]# => q#/(weed|pot).stock/i#,
  q#__KAM_WEIGHT1,[l=1]# => q#/(overweight|extra weight|glutting|shed fat|burns fat|burn calories|appetite suppressant|stimulate your metabolism|unwanted weight|duet of the year|healthy energy boost|Suppresses Appetite|internal cleansing|detoxify|cellulite|unsightly bulges|fat burn|Diet of the year|acai|cuts cholesterol|cleanse excess waste|free sample|unwanted weight|Acai suppl[ie]ments|Diet\/Detox|[hash]1 Weight Loss|lose body fat|(lose|drop) (about )?\d+\s*[li]b|calorie burning machine|before eating carbs)|flush.fat.away|slimming.down|\d+.pounds.gone|lose.\dx|highest.rated.episode|unwanted..?gain|too.goo?d.to.be.true|get.slim|tv.segment|weird.solution/is#,
  q#__KAM_WEIGHT2,[l=1]# => q#/(\d pounds|lose[_ ]weight|suppress appetite|appetite out of control|Oprah|for cancer patients|colon cure|colon cleanse|colonmate|avai berry|acai burn|ultraslim|feel energized|excess[_ ]weight|no diet changes|no exercise|hollywood'?s hottest -?diet|acai berry edge|Acai Diet|top secret diet|Power HCG|Sensa|shocking method|Jennifer Aniston|before eating carbs|all natural weight.?loss|green fruit|top celeb's diet)|one.secret|enjoying.food|f-a-t|melt.fat|squeeze into them|crazy.workout|celebs.everywhere|zero.effort|nothing.to.lose/is#,
  q#__KAM_WEIGHT2_1,[l=0]# => q#/goodbye to her waist|wild transformation/i#,
  q#__KAM_WEIGHT2_3,[l=1]# => q#/melissa mccarthy|now looks \d+/i#,
  q#__KAM_WEIRDTRICK2,[l=1]# => q#/'?(weird|odd|strange)'?.(new.)?(trick|tip)|strange trick|shocking.truth/i#,
  q#__KAM_WHATS3,[l=1]# => q#/WhatsApp/#,
  q#__KAM_WHITEN2,[l=0]# => q#/whitener/i#,
  q#__KAM_WHITEN3,[l=0]# => q#/(Celebrity Smile|Carbamide Peroxide)/i#,
  q#__KAM_WHOSWHO3,[l=1]# => q#/(global|executive) who.s who|represent your community|you have been selected|complete your listing|prominent registry|accomplished individuals/i#,
  q#__KAM_WIFE2,[l=1]# => q#/marry a Russian|sizzling photos|(russian|asian) (women|beauties)|Russian ?bride|Slavic babes|Russian ?lad(y|ies)|russian girl/i#,
  q#__KAM_WINDOWS3,[l=1]# => q#/Find Your Windows|replacement.window|window.design|home.a.new.look|dingy.old.windows|high.heating|high.cooling|let a draft|energy.efficient|double.pane.window|shop.windows|energy.tax|window.(installation|discount|replacement)|summer.is.coming/i#,
  q#__KAM_WORKFROMHOME1,[l=0]# => q#/work from home/i#,
  q#__KAM_WORKHOME1,[l=0]# => q#/online jobs|Full-time (and|&) Part-time|at home employment/i#,
  q#__KAM_WORKHOME2,[l=0]# => q#/[hash]1 site|view here|information here/i#,
  q#__KAM_WRITING3,[l=0]# => q#/Professional Writing|world famous (writer|poet)/i#,
  q#__KAM_WTA2,[l=1]# => q#/Alliance for Retirement Prosperity Association|Social Security Institute/is#,
  q#__KB_WAM_LONELY_WOMEN_PHRASE_01,[l=1]# => q#/\b(I am missing you all the time|I am waiting for your answer|I send you my tender love|I would really like to know you)\b/i#,
  q#__LARGE_PERCENT_AFTER,[l=1]# => q#/\d{3}% after/i#,
  q#__LOTSA_MONEY_05,[l=1]# => q#/(?:(?:sum|value|amount)\sof\s)[1-9][\d.,\sO]{7,20}[\dO\.][\)\]\(\s]{0,3}(?:pounds?|dollars?|euros?|bucks)\b/i#,
  q#__LOTTO_ADMITS_2,[l=1]# => q#/\b(?:free)?(?:lot(?:to|tery|erie)|sweepstakes)\s(?:(?:inter)?na[tz]ional|department|bureau|group|award|microsoft)/i#,
  q#__LOTTO_AGENT_02,[l=1]# => q#/\blot+ery[^\.]{1,40} ticket agent/i#,
  q#__LOTTO_DEPT,[l=1]# => q#/\b(?:claim(?:s|ing)?(?:\sprocessing)?|fiducia\w+|reimbursement|(?:international|foreign|win+ing)(?:\s(?:rem+it+ance|settlement|payment|award))+|payment|award|compensation|lot+ery)(?:\s\w+)?\s?(?:department|dept|unit|group|committee|bureau)/i#,
  q#__LOTTO_VERIFY,[l=1]# => q#/\bpromo\sverification/i#,
  q#__LOTTO_WIN_01,[l=1]# => q#/\bwin+ing\s(?:prize|number|notification|draw|check|cheque|details|information|payment)/i#,
  q#__LUCKY_WINNER,[l=1]# => q#/\b(?:lucky|gl.cklich(?:en)?|afortunados)\s(?:(?:ge)?win+ers?|ganador(?:es)?|individuals?)\b/i#,
  q#__LUCRATIVE,[l=1]# => q#/\b(?:lucrative|profitable|tr[\xe8]s\ssalutaire)\b/i#,
  q#__MAILBOX_FULL_SE,[l=1]# => q#/(?:\b=F6|[\xf6]|[\xc3][\xb6])verskridit gr(?:=E4|[\xe4]|[\xc3][\xa4])nsen f(?:=F6|[\xf6]|[\xc3][\xb6])r din postl(?:=E5|[\xe5]|[\xc3][\xa5])da\b/i#,
  q#__MAIL_ACCT_ACCESS1,[l=1]# => q#/\b(?:your (?:web ?|e-?)?mail (?:account|log-?in) (?:has )?been accessed|r(?:=F3|[\xf3])zne komputery zalogowaniu sie)\b/i#,
  q#__MAIL_ACCT_ACCESS2,[l=1]# => q#/\blo+se ac+es+ to your (?:web|e-?)?mail (?:account|log-?in|box|address)\b/i#,
  q#__MILLIONS,[l=1]# => q#/\bmillions\sof\s(?:dollar|euro|pound)/i#,
  q#__MY_FORTUNE,[l=1]# => q#/\b(?:my|his|her)\s(?:fortune|heritage)\b/i#,
  q#__NEXT_OF_KIN,[l=1]# => q#/\bnext[-\s]of[-\s]kin\b/i#,
  q#__NIGERIA,[l=1]# => q#/\bnigeria\b/i#,
  q#__NOT_DEAD_YET,[l=1]# => q#/\b(?:will\sinherit|que\sherede)\b/i#,
  q#__NOT_SCAM,[l=1]# => q#/\b(?:not\sa\sscam|(?:not|never)\sscam\syou)\b/i#,
  q#__OUR_BEHALF,[l=1]# => q#/\b(?:on\s(?:my|our)\sbehalf|of\sbehalf\sof)\b/i#,
  q#__PAY_YOU,[l=1]# => q#/\bpay\syou\b/#,
  q#__PILL_PRICE_01,[l=1]# => q#m;(?=[\d .f])(?:free|[\d .]{3}(?:/|per|each)) ?(?=[ptc])(?:pill|tablet|cap(?:sule|let))s?\b;i#,
  q#__PILL_PRICE_02,[l=1]# => q#/(?=[ptc])(?:pill|tablet|cap(?:sule|let))s[-= :]{1,5}\$?[\d .]{3}/i#,
  q#__PLS_REVIEW,[l=1]# => q#/\b(?:please|kindly)\s(?:(?:re)?view|see)(?:\s\w+)?\sattach(?:ed|ment)\b/i#,
  q#__PUMPDUMP_01,[l=1]# => q#/\b(?:times|multiply|tripl(?:e|ing)|quadrupl(?:e|ing)|quintupl(?:e|ing)) (?:your|an) (?:princip(?:al|le)|investment)\b/i#,
  q#__PUMPDUMP_03,[l=1]# => q#/\bbuy (?:[^.!]{1,30} )?(?:(?:(?:mon|tues|wednes|thurs|fri)day|tomorrow) (?:first thing|open|morning)|(?:first thing|opens|before) (?:(?:mon|tues|wednes|thurs|fri)day|tomorrow))/i#,
  q#__PUMPDUMP_04,[l=1]# => q#/\bmake you (?:big bucks|hundreds|thousands)\b/i#,
  q#__PUMPDUMP_06,[l=1]# => q#/\brecommend(?:ed|s)? (?:a|this) (?:company|stock)\b/i#,
  q#__PUMPDUMP_07,[l=1]# => q#/\b(?:buy|grab it) for (?:around |about |less than )?\d+ cents\b/i#,
  q#__PUMPDUMP_09,[l=1]# => q#/\b(?:buy|get|snap up|grab) as many shares (?:of it )?as (?:you|I) can\b/i#,
  q#__PUMPDUMP_10,[l=1]# => q#/\btrading at (?:such )?a (?:bargain|cheap|low)\b/i#,
  q#__RANDOM_PICK,[l=1]# => q#/\b(?:random(?:ly)?\s(?:\w+\s)?(?:select(?:ion|ed)|pick(?:ed)?|computer)|(?:select|pick)ed\s(?:at\s)?random(?:ly)?|(?:esco(?:g|lh)idos|seleccion) (?:aleatoria(?:mente)?|al azar))\b/i#,
  q#__RUDE_HTML_1,[l=0]# => q#/Get a capable html e-mailer/i#,
  q#__RUDE_HTML_2,[l=1]# => q#/not support the display of HTML. Please view this message in a different/i#,
  q#__RUDE_HTML_3,[l=0]# => q#/This message contains an HTML formatted message but your email client does/i#,
  q#__RUDE_HTML_4,[l=1]# => q#/Your mailer do not support HTML messages. Switch to a better mailer/i#,
  q#__SCAM,[l=1]# => q#/\bscam(?:m?e[dr])?s?\b/i#,
  q#__SECURITY_DEPT,[l=1]# => q#/\bsecurity dep(?:artmen)?t\b/i#,
  q#__STOCK_TIP,[l=1]# => q#/\bsto[ck]{2}\s?tip\b/i#,
  q#__STYLE_TAG_IN_BODY,[l=1]# => q#/<style(?:[^>]{0,30})?>/i#,
  q#__SUBSCRIPTION_INFO,[l=1]# => q#/\b(?:e?newsletters?|(?:un)?(?:subscrib|register)|you(?:r| are) subscri(?:b|ption)|opt(?:.|ing)?out\b|further info|you do ?n[o']t w(?:ish|ant)|remov\w{1,3}.{1,9}\blists?\b|to your white.?list)/i#,
  q#__SUM_OF_FUND,[l=1]# => q#/\b(?:sum|release|freigabe)\s(?:of|der)\s(?:amount|fund|investment|mittel)\b/i#,
  q#__SURVEY,[l=1]# => q#/\bsurvey\b/i#,
  q#__SYSADMIN,[l=1]# => q#/\b(?:help?[- ]?desk|(?:(?:web ?)?mail ?|sys(?:tem )?)admin(?:istrator)|local[- ]host|(?:support|upgrade|management) (?:team|center)|message from administrator|university mail server copyright|suporte t(?:=E9|[\xe9]|[\xc3][\xa9])cnico|administrador do sistema)\b/i#,
  q#__THEY_INHERIT,[l=1]# => q#/\b(?:inherit\sth(?:e|is)\smoney|herede\sest[ea]\sdinero)\b/i#,
  q#__THIS_AD,[l=1]# => q#/(?:\b|_)this[- _]+(?:ad(?:vert[i1l]sement)?|promo(?:tion)?)s?(?:\b|_)/i#,
  q#__TO_YOUR_ORG,[l=1]# => q#/\b(?:to|for) your organi[sz]ation\b/i#,
  q#__TRAVEL_AGENT,[l=1]# => q#/\btravel\sagen(?:t|cy)\b/i#,
  q#__TRAVEL_BUSINESS,[l=1]# => q#/\bbusiness\stravel\b/i#,
  q#__TRAVEL_ITINERARY,[l=0]# => q#/(?:travel|ticketed|your|current) itinerary/i#,
  q#__TRAVEL_PROFILE,[l=1]# => q#/\btravel+er\sprofile\b/i#,
  q#__TRAVEL_RESERV,[l=1]# => q#/\b(?:reservation\s(?:confirmed|number)|travel\sreservations?)\b/i#,
  q#__TRTMT_DEFILED,[l=1]# => q#/\bdefiled\sall\s(?:forms\sof\s)?(?:medical\s)?treatments?\b/i#,
  q#__TRUNK_BOX,[l=1]# => q#/\b(?:(?:trunk|metallic|proof|security|consignment)\sbox(?:es)?|sealed\ssafe|une mallette m(?:e|=E9|[\xe9]|[\xc3][\xa9])tallique)\b/i#,
  q#__TRUSTED_CHECK,[l=1]# => q#/\b(?:cashier'?s?|certified)\sche(?:ck|que)/i#,
  q#__TVD_PH_BODY_01,[l=1]# => q#/\baccount .{0,20}placed? [io]n restricted status/i#,
  q#__TVD_PH_BODY_02,[l=1]# => q#/\brecords (?:[a-z_,-]+ )+?(?:feature|(?:a|re)ward)/i#,
  q#__TVD_PH_BODY_03,[l=1]# => q#/\byou(?:'ve| have) been (?:[a-z_,-]+ )+?payment/i#,
  q#__TVD_PH_BODY_04,[l=1]# => q#/\bfunds? (?!transfer from)(?!from)(?!in)(?!via)(?:[a-z_,-]+ )+?to your (?:[a-z_,-]+ )*?account/i#,
  q#__TVD_PH_BODY_05,[l=1]# => q#/\bthis is (?:[a-z_,-]+ )+?protect (?:[a-z_,-]+ )+?your/i#,
  q#__TVD_PH_BODY_06,[l=1]# => q#/Dear [a-z]+ bank (?:member|customer)/i#,
  q#__TVD_PH_BODY_07,[l=1]# => q#/\bguarantee the safety of your (?:[a-z_,-]+ )*?account/i#,
  q#__TVD_PH_BODY_08,[l=1]# => q#/\bmultiple password failures/i#,
  q#__TVD_PH_BODY_ACCOUNTS_POST,[l=1]# => q#/\b(?:(?:[dr]e-?)?activat[a-z]*|(?:re-?)?validate|secure|restore|confirm|update|suspend) (?!your)(?:[a-z_,-]+ )+?accounts?\b/i#,
  q#__TVD_PH_BODY_ACCOUNTS_PRE,[l=1]# => q#/\baccounts? (?:[a-z_,-]+ )+?(?:record[a-z]*|suspen[a-z]+|notif(?:y|ication)|updated|verifications?|credited)\b/i#,
  q#__UN,[l=1]# => q#/\bunited\snations?\b/i#,
  q#__VALIDATE_MBOX_SE,[l=1]# => q#/(?:\b=E5|[\xe5]|[\xc3][\xa5])terst(?:=E4|\xe4|[\xc3][\xa4])lla ditt konto\b/i#,
  q#__VBOUNCE_AMAVISD2,[l=1]# => q#/\bV I R U S\b/#,
  q#__VBOUNCE_AOL,[l=1]# => q#/TRANSACTION FAILED - Unrepairable Virus Detected. /#,
  q#__VBOUNCE_ATTACHMENT0,[l=1]# => q#/(?:Attachment.{0,40}was Deleted|the infected attachment)/#,
  q#__VBOUNCE_ATT_QUAR,[l=1]# => q#/\bThe attachment was quarantined\b/#,
  q#__VBOUNCE_AVREPORT0,[l=0]# => q#/(antivirus system report|the antivirus module has|illegal attachment|Unrepairable Virus Detected)/i#,
  q#__VBOUNCE_CLICKBANK,[l=1]# => q#/\bvirus scanner deleted your message\b/i#,
  q#__VBOUNCE_DUTCH,[l=1]# => q#/bevatte bijlage besmet welke besmet was met een virus/#,
  q#__VBOUNCE_EXIM,[l=1]# => q#/a potentially executable attachment /#,
  q#__VBOUNCE_GUIN,[l=1]# => q#/message contains file attachments that are not permitted/#,
  q#__VBOUNCE_MAILMARSHAL,[l=1]# => q#/Mail.?Marshal Rule: Inbound Messages : Block Dangerous Attachments/#,
  q#__VBOUNCE_MAILSWEEP,[l=1]# => q#/MAILsweeper has found that a \S+ \S+ \S+ \S+ one or more virus/#,
  q#__VBOUNCE_MAILSWEEP2,[l=1]# => q#/\bblocked by Mailsweeper\b/i#,
  q#__VBOUNCE_QUOTED_EXE,[l=1]# => q#/> TVqQAAMAAAAEAAAA/#,
  q#__VBOUNCE_REJ_FILT,[l=1]# => q#/Reason: Rejected by filter/#,
  q#__VBOUNCE_SECURIQ,[l=1]# => q#/\bGROUP securiQ.Wall\b/#,
  q#__VBOUNCE_SMTP,[l=1]# => q#/host \S+ said: 5\d\d\s+Error: Message content rejected/#,
  q#__VBOUNCE_STRIP_ATTACH,[l=1]# => q#/\bhas stripped one or more attachments from the following message\b/#,
  q#__VBOUNCE_VALERT,[l=1]# => q#/The mail message \S+ \S+ you sent to \S+ contains the virus/#,
  q#__WEBMAIL_ACCT,[l=1]# => q#/\byour web ?mail account/i#,
  q#__WIDOW,[l=1]# => q#/\b(?:widow(?:e[rd])'?s?|veuve)\b/i#,
  q#__WILL_LEGAL,[l=1]# => q#/\b(?:codicil|last\stestament|probate|executor|intestate|bequest|mandamus)\b/i#,
  q#__WIRE_XFR,[l=1]# => q#/\b(?:wire|telegraph(?:ic)?|bank)\s?transfer/i#,
  q#__YOUR_BANK,[l=1]# => q#/\byour?\s(?:full\s)?bank(?:ing)?\sinformations?\b/i#,
  q#__YOUR_FUND,[l=1]# => q#/\b(?:your|ihr)\s(?:unpaid\s|win+ing\s|ap+roved\s|foreign\s|overdue\s|outstanding\s|contract\s|inheritance\s|nicht\sausbezahlten\s){0,3}(?:fund|payment|geld)\b/i#,
  q#__YOUR_PERM,[l=1]# => q#/\byour\spermission\b/i#,
  q#__YOUR_PROFIT,[l=1]# => q#/\byour?\sprofit/i#,
  q#__YOU_ASSIST,[l=1]# => q#/\b(?:your\sas+istan(?:ce|t)|votre\s(?:as+istance|aide))\b/i#,
  q#__YOU_INHERIT,[l=1]# => q#/\byour\s[a-z\s]{0,30}inherit+ance\b/i#,
  q#__YOU_WON_01,[l=1]# => q#/\byou(?:r|'re|'ve|'ll|\shave|\sdid)?\s(?:e-?mail\s)?(?:\w+\s){0,2}(?:a\s)?w[io]n+(?:er|ing)?(?!'t)\b/i#,
  q#__YOU_WON_02,[l=1]# => q#/\bw[io]n\s(?:(?:for|by)\s)?your?\b/i#,
  q#__YOU_WON_04,[l=1]# => q#/\bqu[ei]\s?(?:vous (?:[\xc3][\xaa]|=C3=AA|[\xea]|e)tes\s?gagnant|en\scons(?:e|=E9|[\xe9]|[\xc3][\xa9])quence\sgagne)\b/i#,
  q#__YOU_WON_05,[l=1]# => q#/\bI won\b/i#,
  q#__freemail_safe_fwd,[l=1]# => q#/---\s?(?:(?:Forwarded|Original) message|Alkuper.inen viesti)/i#,

};

XSLoader::load 'Mail::SpamAssassin::CompiledRegexps::body_0', $VERSION;
}

1;
__END__

=head1 NAME

Mail::SpamAssassin::CompiledRegexps::body_0 - Efficient string matching for regexps found in bases_body_0.in

=head1 SYNOPSIS

  use Mail::SpamAssassin::CompiledRegexps::body_0;
  
  ...
  my $match = Mail::SpamAssassin::CompiledRegexps::body_0::scan($string);

=head1 DESCRIPTION

This module was created by SpamAssassin with the aid of re2xs, which uses re2c
to create an XS library capable of scanning through a bunch of regular
expressions as defined in F<bases_body_0.in>.

See C<sa-compile> for more details.

=cut
