$j(document).ready(function() {
  let dnsTemplateFormat = $j('#dns-template').html();
  let dnsTemplate = Handlebars.compile(dnsTemplateFormat);
  let errorHolder = $j('#check_error');
  let errorMessage = $j('#validator_checkerror');
  let loadingHolder = $j('#loading-div');
  let domainPanel = $j('#records_accordian');
  let failAttempts = 0;
  $j('#retry-checks').on('click', function() {
    failAttempts = 0;
    loadingHolder.show();
    errorHolder.hide();
    checkDomains();
  })

  errorHolder.hide();
  loadingHolder.show();

  async function parseDomains(response) {
    if(response.domains == null)
    {
      errorHolder.show();
      return false;
    }
    for(const domain of response.domains)
    {
      if(domain !== null)
      {
        domainPanel.append(dnsTemplate(domain));
      }
    }
    loadingHolder.hide();

    domainPanel.fadeIn(500);

    $j('.collapse').on('show.bs.collapse', function(event) {
      $j(event.target).closest('.panel').find('.arw').html('&#9660;');
    });
    $j('.collapse').on('hide.bs.collapse', function(event) {
      $j(event.target).closest('.panel').find('.arw').html('&#9658;');
    });

    if(response.domains.length == 1)
    {
      $j('.collapse').first().collapse('show');
    }

    $j('.copy-button').on('click', function() {
      const button = $j(this);
      const value = button.data('value');
      if(button.hasClass('copied')) return false;
      navigator.clipboard.writeText(value).then(() => {
        button.addClass('copied');
        let old_html = button.html();
        button.html('<i class="fas fa-check"></i> Copied!');

        setTimeout(() => {
          button.removeClass('copied')
          button.html(old_html);
        }, 2000)
      });
    })
  }

  async function showError(error)
  {
    if(error == "timeout")
    {
      errorMessage.html(
        "<span>Failed to run the SPF checks due to timeout being reached. Please try again.</span>"
      )
    }else if(error == "stdin_fail")
    {
      if(failAttempts >= 2)
      {
        errorMessage.html(
          "<span>Failed to run the SPF checks several times. Please try again.</span>"
        )
      }else{
        failAttempts += 1;
        console.log("Caught SPF Check stdin failure attempt: ", failAttempts)
        checkDomains();
        return;
      }
    }else{
      errorMessage.html(
        "<span>Failed to run the SPF checks. Please try again.</span>"
      )
    }
    loadingHolder.hide();
    errorHolder.show();
  }

  async function checkDomains() {
    domainPanel.hide();
    domainPanel.html("");
    try {
      const response = await $j.ajax({
        url: 'run-check.live.php',
        method: 'GET',
        dataType: 'json'
      });
      if(response.error)
      {
        showError(response.error);
      }else{
        failAttempts = 0;
        parseDomains(response);
      }
    } catch (error) {
      showError("unknown");
      console.error("Error checking domains: ", error);
    } finally {
    }
  }
  checkDomains();

});
