#!/bin/bash
# VPS RADS Tools, written by Erik Soroka (eriks@imhadmin.net, ext 834)
# This tool finds the largest domlogs and sends in an STR for action
if [ -f /etc/cpanel/ea4/is_ea4 ]; then
    DOMLOG_DIR=/var/log/apache2/domlogs
else
    DOMLOG_DIR=/usr/local/apache/domlogs
fi
# get the largest domlogs for review
for log in $(ls -la "$DOMLOG_DIR" | sort -nk5 | tail -20 | awk '{print $9}'); do
    logsize=$(stat -c %s "${DOMLOG_DIR}/${log}")
    if [ "$logsize" -gt 2161691136 ]; then
    # send in an STR for action
    echo "oversized log detected: $log -- opened STR"
    echo "An oversized domlog file has been detected and needs to be reviewed, removed, or truncated." && ls -lah "${DOMLOG_DIR}/${log}" | /opt/sharedrads/strmailer -u root -s "Oversized Log Detected: $log" -e str@imhadmin.net
fi

done

# EOF
